/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.tuis.dominion;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.cache.DominionNode;
import cn.lunadeer.dominion.cache.server.ServerCache;
import cn.lunadeer.dominion.commands.DominionOperateCommand;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.managers.MultiServerManager;
import cn.lunadeer.dominion.managers.TeleportManager;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.tuis.MainMenu;
import cn.lunadeer.dominion.uis.tuis.dominion.DominionManage;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.ViewStyles;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DominionList {
    public static SecondaryCommand list = new SecondaryCommand("list", List.of(new CommandArguments.OptionalPageArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            try {
                DominionList.show(sender, this.getArgumentValue(0));
            }
            catch (Exception e) {
                Notification.error(sender, e.getMessage());
            }
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static ListViewButton button(final CommandSender sender) {
        return (ListViewButton)new ListViewButton(Language.dominionListTuiText.button){

            @Override
            public void function(String pageStr) {
                DominionList.show(sender, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    public static void show(CommandSender sender, String pageStr) {
        try {
            Player player = Converts.toPlayer(sender);
            int page = Converts.toIntegrity(pageStr);
            ListView view = ListView.create(10, DominionList.button(sender));
            view.title(Language.dominionListTuiText.title);
            view.navigator(Line.create().append(MainMenu.button(sender).build()).append(Language.dominionListTuiText.button));
            CopyOnWriteArrayList<DominionNode> dominionNodes = CacheManager.instance.getCache().getDominionCache().getPlayerDominionNodes(player.getUniqueId());
            view.addLines(DominionList.BuildTreeLines(sender, dominionNodes, 0));
            List<DominionDTO> admin_dominions = CacheManager.instance.getCache().getDominionCache().getPlayerAdminDominionDTOs(player.getUniqueId());
            if (!admin_dominions.isEmpty()) {
                view.add(Line.create().append(""));
                view.add(Line.create().append(Component.text((String)Language.dominionListTuiText.adminSection, (TextColor)ViewStyles.main_color)));
                for (DominionDTO dominion : admin_dominions) {
                    TextComponent manage = DominionManage.button(sender, dominion.getName()).build();
                    view.add(Line.create().append(manage).append(dominion.getName()));
                }
            }
            if (Configuration.multiServer.enable) {
                for (ServerCache serverCache : CacheManager.instance.getOtherServerCaches().values()) {
                    view.add(Line.create().append(""));
                    view.add(Line.create().append(Component.text((String)Misc.formatString(Language.dominionListTuiText.serverSection, MultiServerManager.instance.getServerName(serverCache.getServerId())), (TextColor)ViewStyles.main_color)));
                    view.addLines(DominionList.BuildTreeLines(sender, serverCache.getDominionCache().getPlayerDominionNodes(player.getUniqueId()), 0));
                    List<DominionDTO> admin_dominions_others = serverCache.getDominionCache().getPlayerAdminDominionDTOs(player.getUniqueId());
                    if (admin_dominions_others.isEmpty()) continue;
                    for (DominionDTO dominion : admin_dominions_others) {
                        TextComponent manage = DominionManage.button(sender, dominion.getName()).build();
                        view.add(Line.create().append(manage).append(dominion.getName()));
                    }
                }
            }
            view.showOn((CommandSender)player, page);
        }
        catch (Exception e) {
            Notification.error(sender, e.getMessage());
        }
    }

    public static List<Line> BuildTreeLines(final CommandSender sender, List<DominionNode> dominionTree, Integer depth) {
        ArrayList<Line> lines = new ArrayList<Line>();
        StringBuilder prefix = new StringBuilder();
        prefix.append(" | ".repeat(Math.max(0, depth)));
        for (final DominionNode node : dominionTree) {
            TextComponent manage = DominionManage.button(sender, node.getDominion().getName()).green().build();
            TextComponent delete = new FunctionalButton(Language.dominionListTuiText.deleteButton){

                @Override
                public void function() {
                    DominionOperateCommand.delete(sender, node.getDominion().getName(), "");
                }
            }.red().build();
            TextComponent tp = new FunctionalButton("TP"){

                @Override
                public void function() {
                    if (sender instanceof Player) {
                        Player player = (Player)sender;
                        TeleportManager.teleportToDominion(player, node.getDominion());
                    }
                }
            }.build();
            Line line = Line.create().append(delete).append(manage).append(tp).append(String.valueOf(prefix) + node.getDominion().getName());
            lines.add(line);
            lines.addAll(DominionList.BuildTreeLines(sender, node.getChildren(), depth + 1));
        }
        return lines;
    }

    public static class DominionListTuiText
    extends ConfigurationPart {
        public String title = "Your Dominions";
        public String button = "DOMINIONS";
        public String description = "List all of your dominions.";
        public String deleteButton = "DELETE";
        public String adminSection = "Your admin dominions section.";
        public String serverSection = "Server {0} dominions section.";
    }
}

