/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.tuis.template;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.commands.TemplateCommand;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.doos.TemplateDOO;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.inputters.CreateTemplateInputter;
import cn.lunadeer.dominion.uis.tuis.MainMenu;
import cn.lunadeer.dominion.uis.tuis.template.TemplateSetting;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.Button;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TemplateList {
    public static ListViewButton button(final CommandSender sender) {
        return (ListViewButton)new ListViewButton(Language.templateListTuiText.button){

            @Override
            public void function(String pageStr) {
                TemplateList.show(sender, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    public static void show(final CommandSender sender, String pageStr) {
        try {
            Player player = Converts.toPlayer(sender);
            int page = Converts.toIntegrity(pageStr, 1);
            List<TemplateDOO> templates = TemplateDOO.selectAll(player.getUniqueId());
            ListView view = ListView.create(10, TemplateList.button(sender));
            view.title(Language.templateListTuiText.title);
            view.navigator(Line.create().append(MainMenu.button(sender).build()).append(Language.templateListTuiText.button));
            view.add(Line.create().append(CreateTemplateInputter.createEnterOn(sender).needPermission(Dominion.defaultPermission).build()));
            for (final TemplateDOO template : templates) {
                Button setting = TemplateSetting.button(sender, template.getName()).green();
                Button delete = new ListViewButton(Language.templateListTuiText.deleteButton){

                    @Override
                    public void function(String pageStr) {
                        TemplateCommand.deleteTemplate(sender, template.getName(), pageStr);
                    }
                }.needPermission(Dominion.defaultPermission).red();
                Line line = Line.create().append(delete.build()).append(setting.build()).append(template.getName());
                view.add(line);
            }
            view.showOn((CommandSender)player, page);
        }
        catch (Exception e) {
            Notification.error(sender, e.getMessage());
        }
    }

    public static class TemplateListTuiText
    extends ConfigurationPart {
        public String title = "Template List";
        public String button = "TEMPLATES";
        public String description = "Templates can be used to quickly setup privileges of member.";
        public String deleteButton = "DELETE";
    }
}

