/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.tuis.template;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import cn.lunadeer.dominion.commands.TemplateCommand;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.doos.TemplateDOO;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.tuis.MainMenu;
import cn.lunadeer.dominion.uis.tuis.template.TemplateList;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TemplateSetting {
    public static ListViewButton button(final CommandSender sender, final String templateName) {
        return (ListViewButton)new ListViewButton(Language.templateSettingText.button){

            @Override
            public void function(String pageStr) {
                TemplateSetting.show(sender, templateName, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    public static void show(CommandSender sender, String templateName, String pageStr) {
        try {
            Player player = Converts.toPlayer(sender);
            TemplateDOO template = TemplateDOO.select(player.getUniqueId(), templateName);
            if (template == null) {
                Notification.error(sender, Language.templateSettingText.notFound, templateName);
                return;
            }
            ListView view = ListView.create(10, TemplateSetting.button(sender, templateName));
            view.title(Language.templateSettingText.title);
            view.navigator(Line.create().append(MainMenu.button(sender).build()).append(TemplateList.button(sender).build()).append(Language.templateSettingText.button));
            for (PriFlag flag : Flags.getAllPriFlagsEnable()) {
                view.add(TemplateSetting.createOption(sender, flag, template.getFlagValue(flag), template.getName(), pageStr));
            }
            view.showOn((CommandSender)player, Converts.toIntegrity(pageStr));
        }
        catch (Exception e) {
            Notification.error(sender, e.getMessage());
        }
    }

    private static Line createOption(final CommandSender sender, final PriFlag flag, boolean value, final String templateName, final String pageStr) {
        if (value) {
            return Line.create().append(new FunctionalButton("\u2611"){

                @Override
                public void function() {
                    TemplateCommand.setTemplateFlag(sender, templateName, flag.getFlagName(), "false", pageStr);
                }
            }.needPermission(Dominion.defaultPermission).green().build()).append((TextComponent)Component.text((String)flag.getDisplayName()).hoverEvent((HoverEventSource)Component.text((String)flag.getDescription())));
        }
        return Line.create().append(new FunctionalButton("\u2610"){

            @Override
            public void function() {
                TemplateCommand.setTemplateFlag(sender, templateName, flag.getFlagName(), "true", pageStr);
            }
        }.needPermission(Dominion.defaultPermission).red().build()).append((TextComponent)Component.text((String)flag.getDisplayName()).hoverEvent((HoverEventSource)Component.text((String)flag.getDescription())));
    }

    public static class TemplateSettingText
    extends ConfigurationPart {
        public String title = "Template Setting";
        public String button = "SETTING";
        public String notFound = "Template {0} not found.";
    }
}

