/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.databse.FIelds;

import cn.lunadeer.dominion.utils.databse.DatabaseManager;
import cn.lunadeer.dominion.utils.databse.DatabaseType;
import cn.lunadeer.dominion.utils.databse.FIelds.Field;
import java.util.List;

public class FieldInteger
extends Field<Integer> {
    private Integer value;

    public FieldInteger(String name) {
        super(name);
    }

    public FieldInteger(String name, Integer value) {
        super(name);
        this.value = value;
    }

    @Override
    public String getSqlTypeStr() {
        return FieldInteger.getTypeStrings().get(0);
    }

    @Override
    public String getUnifyTypeStr() {
        return "INTEGER";
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public Field<Integer> setValue(Integer value) {
        this.value = value;
        return this;
    }

    public static List<String> getTypeStrings() {
        return switch (DatabaseManager.instance.getType()) {
            case DatabaseType.MYSQL -> List.of("INT", "INTEGER", "INT(11)");
            case DatabaseType.SQLITE -> List.of("INTEGER", "INT");
            case DatabaseType.PGSQL -> List.of("INTEGER", "INT");
            default -> throw new UnsupportedOperationException("Database type: " + String.valueOf((Object)DatabaseManager.instance.getType()) + " not supported FieldInteger");
        };
    }
}

