/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.databse.syntax.Table;

import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.databse.DatabaseManager;
import cn.lunadeer.dominion.utils.databse.DatabaseType;
import cn.lunadeer.dominion.utils.databse.syntax.Syntax;
import cn.lunadeer.dominion.utils.databse.syntax.Table.Column;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public abstract class Create
implements Syntax {
    protected String tableName;
    protected List<Column> columns = new ArrayList<Column>();

    public static Create create() {
        return switch (DatabaseManager.instance.getType()) {
            case DatabaseType.PGSQL, DatabaseType.SQLITE -> new pgsql_sqlite_impl();
            case DatabaseType.MYSQL -> new mysql_impl();
            default -> throw new UnsupportedOperationException("Database type: " + String.valueOf((Object)DatabaseManager.instance.getType()) + " not supported with CREATE");
        };
    }

    private Create() {
    }

    public Create table(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public Create column(Column column) {
        this.columns.add(column);
        return this;
    }

    public void execute() throws SQLException {
        try (Connection connection = DatabaseManager.instance.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeUpdate(this.getSql());
        }
        catch (SQLException e) {
            XLogger.error("SQL: " + this.getSql());
            XLogger.error(e);
            throw new SQLException("Error executing CREATE TABLE statement: " + this.getSql(), e);
        }
    }

    @Override
    public String getSql() {
        StringBuilder sql = new StringBuilder("CREATE TABLE IF NOT EXISTS " + this.tableName + " (");
        for (int i = 0; i < this.columns.size(); ++i) {
            Column column = this.columns.get(i);
            sql.append(column.getSql());
            if (i >= this.columns.size() - 1) continue;
            sql.append(", ");
        }
        sql.append(")");
        return sql.toString();
    }

    private static class pgsql_sqlite_impl
    extends Create {
        private pgsql_sqlite_impl() {
        }

        @Override
        public String getSql() {
            return super.getSql();
        }
    }

    private static class mysql_impl
    extends Create {
        private mysql_impl() {
        }

        @Override
        public String getSql() {
            return super.getSql() + " ENGINE=InnoDB";
        }
    }
}

