/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.stui.inputter;

import cn.lunadeer.dominion.utils.scheduler.Scheduler;
import cn.lunadeer.dominion.utils.stui.inputter.InputterRunner;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Inputter
implements Listener {
    private static Inputter instance;
    private final Map<Player, InputterRunner> cachedInputters;

    public static Inputter getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Inputter has not been initialized. Please call Inputter.init(plugin) first.");
        }
        return instance;
    }

    public Inputter(JavaPlugin plugin) {
        instance = this;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.cachedInputters = new HashMap<Player, InputterRunner>();
    }

    public void register(InputterRunner inputterRunner) {
        this.cachedInputters.put(inputterRunner.getSender(), inputterRunner);
    }

    public void unregister(InputterRunner inputterRunner) {
        this.cachedInputters.remove(inputterRunner.getSender());
    }

    @EventHandler
    public void onPlayerInput(AsyncPlayerChatEvent event) {
        Player sender = event.getPlayer();
        if (!this.cachedInputters.containsKey(sender)) {
            return;
        }
        event.setCancelled(true);
        Scheduler.runTask(() -> this.cachedInputters.get(sender).runner(event.getMessage()));
    }

    @EventHandler
    public void onPlayerLogout(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.cachedInputters.remove(player);
    }
}

