/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.cache;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.misc.DominionException;
import cn.lunadeer.dominion.misc.Others;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public class DominionNode {
    private final Integer dominionId;
    private CopyOnWriteArrayList<DominionNode> children = new CopyOnWriteArrayList();

    public DominionNode(Integer dominionId) {
        this.dominionId = dominionId;
    }

    @NotNull
    public DominionDTO getDominion() {
        DominionDTO dominion = CacheManager.instance.getDominion(this.dominionId);
        if (dominion == null) {
            throw new DominionException(Language.convertsText.unknownDominion, this.dominionId);
        }
        return dominion;
    }

    public CopyOnWriteArrayList<DominionNode> getChildren() {
        return this.children;
    }

    public static CopyOnWriteArrayList<DominionNode> BuildNodeTree(Integer rootId, CopyOnWriteArrayList<DominionDTO> dominions) {
        ConcurrentHashMap<Integer, CopyOnWriteArrayList<DominionDTO>> parentToChildrenMap = new ConcurrentHashMap<Integer, CopyOnWriteArrayList<DominionDTO>>();
        dominions.forEach(dominion -> parentToChildrenMap.computeIfAbsent(dominion.getParentDomId(), k -> new CopyOnWriteArrayList()).add(dominion));
        return DominionNode.buildTree(rootId, parentToChildrenMap);
    }

    private static CopyOnWriteArrayList<DominionNode> buildTree(Integer rootId, ConcurrentHashMap<Integer, CopyOnWriteArrayList<DominionDTO>> parentToChildrenMap) {
        CopyOnWriteArrayList<DominionNode> dominionTree = new CopyOnWriteArrayList<DominionNode>();
        CopyOnWriteArrayList<DominionDTO> children = parentToChildrenMap.get(rootId);
        if (children != null) {
            for (DominionDTO dominion : children) {
                DominionNode node = new DominionNode(dominion.getId());
                node.children = DominionNode.buildTree(dominion.getId(), parentToChildrenMap);
                dominionTree.add(node);
            }
        }
        return dominionTree;
    }

    public static DominionNode getDominionNodeByLocation(@NotNull CopyOnWriteArrayList<DominionNode> nodes, @NotNull Location loc) {
        for (DominionNode node : nodes) {
            if (!Others.isInDominion(node.getDominion(), loc)) continue;
            if (node.children.isEmpty()) {
                return node;
            }
            DominionNode childDominion = DominionNode.getDominionNodeByLocation(node.children, loc);
            return Objects.requireNonNullElse(childDominion, node);
        }
        return null;
    }
}

