/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.tuis.dominion.manage;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.flag.EnvFlag;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.commands.DominionFlagCommand;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.tuis.MainMenu;
import cn.lunadeer.dominion.uis.tuis.dominion.DominionList;
import cn.lunadeer.dominion.uis.tuis.dominion.DominionManage;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.command.CommandSender;

public class EnvSetting {
    public static ListViewButton button(final CommandSender sender, final String dominionName) {
        return (ListViewButton)new ListViewButton(Language.envSettingTuiText.button){

            @Override
            public void function(String pageStr) {
                EnvSetting.show(sender, dominionName, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    public static void show(final CommandSender sender, final String dominionName, final String pageStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            Asserts.assertDominionAdmin(sender, dominion);
            int page = Converts.toIntegrity(pageStr);
            ListView view = ListView.create(10, EnvSetting.button(sender, dominionName));
            view.title(Misc.formatString(Language.envSettingTuiText.title, dominion.getName())).navigator(Line.create().append(MainMenu.button(sender).build()).append(DominionList.button(sender).build()).append(DominionManage.button(sender, dominionName).build()).append(Language.envSettingTuiText.button));
            for (final EnvFlag flag : Flags.getAllEnvFlagsEnable()) {
                if (dominion.getEnvFlagValue(flag)) {
                    view.add(Line.create().append(new FunctionalButton("\u2611"){

                        @Override
                        public void function() {
                            DominionFlagCommand.setEnv(sender, dominionName, flag.getFlagName(), "false", pageStr);
                        }
                    }.needPermission(Dominion.defaultPermission).green().build()).append((TextComponent)Component.text((String)flag.getDisplayName()).hoverEvent((HoverEventSource)Component.text((String)flag.getDescription()))));
                    continue;
                }
                view.add(Line.create().append(new FunctionalButton("\u2610"){

                    @Override
                    public void function() {
                        DominionFlagCommand.setEnv(sender, dominionName, flag.getFlagName(), "true", pageStr);
                    }
                }.needPermission(Dominion.defaultPermission).red().build()).append((TextComponent)Component.text((String)flag.getDisplayName()).hoverEvent((HoverEventSource)Component.text((String)flag.getDescription()))));
            }
            view.showOn(sender, page);
        }
        catch (Exception e) {
            Notification.error(sender, e.getMessage());
        }
    }

    public static class EnvSettingTuiText
    extends ConfigurationPart {
        public String title = "{0} Env Setting";
        public String button = "ENV SET";
        public String description = "Set environment of dominion.";
    }
}

