/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.cache;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.cache.DominionNode;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.utils.AutoTimer;
import cn.lunadeer.dominion.utils.XLogger;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public class DominionNodeSectored {
    private ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> world_dominion_tree_sector_a;
    private ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> world_dominion_tree_sector_b;
    private ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> world_dominion_tree_sector_c;
    private ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> world_dominion_tree_sector_d;
    private Integer section_origin_x = 0;
    private Integer section_origin_z = 0;

    public DominionDTO getDominionByLocation(@NotNull Location loc) {
        try (AutoTimer ignored = new AutoTimer(Configuration.timer);){
            CopyOnWriteArrayList<DominionNode> nodes = this.getNodes(loc);
            if (nodes == null) {
                DominionDTO dominionDTO = null;
                return dominionDTO;
            }
            if (nodes.isEmpty()) {
                DominionDTO dominionDTO = null;
                return dominionDTO;
            }
            DominionNode dominionNode = DominionNode.getDominionNodeByLocation(nodes, loc);
            DominionDTO dominionDTO = dominionNode == null ? null : dominionNode.getDominion();
            return dominionDTO;
        }
    }

    public CopyOnWriteArrayList<DominionNode> getNodes(@NotNull Location loc) {
        return this.getNodes(loc.getWorld().getUID(), loc.getBlockX(), loc.getBlockZ());
    }

    public CopyOnWriteArrayList<DominionNode> getNodes(World world, int x, int z) {
        return this.getNodes(world.getUID(), x, z);
    }

    public CopyOnWriteArrayList<DominionNode> getNodes(UUID world, int x, int z) {
        if (x >= this.section_origin_x && z >= this.section_origin_z) {
            if (this.world_dominion_tree_sector_a == null) {
                return null;
            }
            return this.world_dominion_tree_sector_a.get(world);
        }
        if (x <= this.section_origin_x && z >= this.section_origin_z) {
            if (this.world_dominion_tree_sector_b == null) {
                return null;
            }
            return this.world_dominion_tree_sector_b.get(world);
        }
        if (x >= this.section_origin_x) {
            if (this.world_dominion_tree_sector_c == null) {
                return null;
            }
            return this.world_dominion_tree_sector_c.get(world);
        }
        if (this.world_dominion_tree_sector_d == null) {
            return null;
        }
        return this.world_dominion_tree_sector_d.get(world);
    }

    public void build(CopyOnWriteArrayList<DominionNode> nodes) {
        try (AutoTimer ignored = new AutoTimer(Configuration.timer);){
            this.world_dominion_tree_sector_a = new ConcurrentHashMap();
            this.world_dominion_tree_sector_b = new ConcurrentHashMap();
            this.world_dominion_tree_sector_c = new ConcurrentHashMap();
            this.world_dominion_tree_sector_d = new ConcurrentHashMap();
            int max_x = nodes.stream().mapToInt(n -> n.getDominion().getCuboid().x2()).max().orElse(0);
            int min_x = nodes.stream().mapToInt(n -> n.getDominion().getCuboid().x1()).min().orElse(0);
            int max_z = nodes.stream().mapToInt(n -> n.getDominion().getCuboid().z2()).max().orElse(0);
            int min_z = nodes.stream().mapToInt(n -> n.getDominion().getCuboid().z1()).min().orElse(0);
            this.section_origin_x = (max_x + min_x) / 2;
            this.section_origin_z = (max_z + min_z) / 2;
            XLogger.debug("Cache init section origin: {0}, {1}", this.section_origin_x, this.section_origin_z);
            for (DominionNode n2 : nodes) {
                DominionDTO d = n2.getDominion();
                if (!(this.world_dominion_tree_sector_a.containsKey(d.getWorldUid()) && this.world_dominion_tree_sector_b.containsKey(d.getWorldUid()) && this.world_dominion_tree_sector_c.containsKey(d.getWorldUid()) && this.world_dominion_tree_sector_d.containsKey(d.getWorldUid()))) {
                    this.world_dominion_tree_sector_a.put(d.getWorldUid(), new CopyOnWriteArrayList());
                    this.world_dominion_tree_sector_b.put(d.getWorldUid(), new CopyOnWriteArrayList());
                    this.world_dominion_tree_sector_c.put(d.getWorldUid(), new CopyOnWriteArrayList());
                    this.world_dominion_tree_sector_d.put(d.getWorldUid(), new CopyOnWriteArrayList());
                }
                if (d.getCuboid().x1() >= this.section_origin_x && d.getCuboid().z1() >= this.section_origin_z) {
                    this.world_dominion_tree_sector_a.get(d.getWorldUid()).add(n2);
                    continue;
                }
                if (d.getCuboid().x1() <= this.section_origin_x && d.getCuboid().z1() >= this.section_origin_z) {
                    if (d.getCuboid().x2() >= this.section_origin_x) {
                        this.world_dominion_tree_sector_a.get(d.getWorldUid()).add(n2);
                        this.world_dominion_tree_sector_b.get(d.getWorldUid()).add(n2);
                        continue;
                    }
                    this.world_dominion_tree_sector_b.get(d.getWorldUid()).add(n2);
                    continue;
                }
                if (d.getCuboid().x1() >= this.section_origin_x && d.getCuboid().z1() <= this.section_origin_z) {
                    if (d.getCuboid().z2() >= this.section_origin_z) {
                        this.world_dominion_tree_sector_a.get(d.getWorldUid()).add(n2);
                        this.world_dominion_tree_sector_c.get(d.getWorldUid()).add(n2);
                        continue;
                    }
                    this.world_dominion_tree_sector_c.get(d.getWorldUid()).add(n2);
                    continue;
                }
                if (d.getCuboid().x2() >= this.section_origin_x && d.getCuboid().z2() >= this.section_origin_z) {
                    this.world_dominion_tree_sector_a.get(d.getWorldUid()).add(n2);
                    this.world_dominion_tree_sector_b.get(d.getWorldUid()).add(n2);
                    this.world_dominion_tree_sector_c.get(d.getWorldUid()).add(n2);
                    this.world_dominion_tree_sector_d.get(d.getWorldUid()).add(n2);
                    continue;
                }
                if (d.getCuboid().x2() >= this.section_origin_x && d.getCuboid().z2() <= this.section_origin_z) {
                    this.world_dominion_tree_sector_c.get(d.getWorldUid()).add(n2);
                    this.world_dominion_tree_sector_d.get(d.getWorldUid()).add(n2);
                    continue;
                }
                if (d.getCuboid().z2() >= this.section_origin_z && d.getCuboid().x2() <= this.section_origin_x) {
                    this.world_dominion_tree_sector_b.get(d.getWorldUid()).add(n2);
                    this.world_dominion_tree_sector_d.get(d.getWorldUid()).add(n2);
                    continue;
                }
                this.world_dominion_tree_sector_d.get(d.getWorldUid()).add(n2);
            }
        }
    }
}

