/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.cache.server;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.cache.DominionNode;
import cn.lunadeer.dominion.cache.DominionNodeSectored;
import cn.lunadeer.dominion.cache.server.Cache;
import cn.lunadeer.dominion.doos.DominionDOO;
import cn.lunadeer.dominion.utils.XLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DominionCache
extends Cache {
    private final Integer serverId;
    private ConcurrentHashMap<Integer, DominionDTO> idDominions;
    private ConcurrentHashMap<Integer, CopyOnWriteArrayList<Integer>> dominionChildrenMap;
    private ConcurrentHashMap<String, Integer> dominionNameToId;
    private ConcurrentHashMap<UUID, CopyOnWriteArrayList<Integer>> playerOwnDominions;
    private ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> playerDominionNodes;
    private ConcurrentHashMap<Integer, DominionNode> dominionNodeMap;
    private final DominionNodeSectored dominionNodeSectored = new DominionNodeSectored();

    public DominionCache(Integer serverId) {
        this.serverId = serverId;
    }

    @Nullable
    public DominionDTO getDominion(@NotNull Integer id) {
        return this.idDominions.get(id);
    }

    @Nullable
    public DominionDTO getDominion(String name) {
        Integer id = this.dominionNameToId.get(name);
        try {
            if (id == null) {
                return DominionDOO.select(name);
            }
        }
        catch (Exception e) {
            return null;
        }
        return this.getDominion(id);
    }

    @Nullable
    public DominionDTO getDominion(@NotNull Location location) {
        return this.dominionNodeSectored.getDominionByLocation(location);
    }

    @NotNull
    public CopyOnWriteArrayList<DominionNode> getPlayerDominionNodes(UUID player) {
        return this.playerDominionNodes.getOrDefault(player, new CopyOnWriteArrayList());
    }

    @NotNull
    public List<DominionNode> getAllDominionNodes() {
        return new ArrayList<DominionNode>(this.dominionNodeMap.values());
    }

    @NotNull
    public List<DominionDTO> getChildrenOf(Integer id) {
        if (this.dominionChildrenMap.containsKey(id)) {
            return this.dominionChildrenMap.get(id).stream().map(this::getDominion).toList();
        }
        return new ArrayList<DominionDTO>();
    }

    public List<String> getAllDominionNames() {
        return new ArrayList<String>(this.dominionNameToId.keySet());
    }

    public CopyOnWriteArrayList<DominionDTO> getPlayerOwnDominionDTOs(UUID player) {
        CopyOnWriteArrayList dominionIds = this.playerOwnDominions.getOrDefault(player, new CopyOnWriteArrayList());
        CopyOnWriteArrayList<DominionDTO> dominions = new CopyOnWriteArrayList<DominionDTO>();
        for (Integer id : dominionIds) {
            dominions.add(this.getDominion(id));
        }
        return dominions;
    }

    public List<DominionDTO> getPlayerAdminDominionDTOs(UUID player) {
        ArrayList<DominionDTO> dominions = new ArrayList<DominionDTO>();
        List<MemberDTO> playerBelongedDominionMembers = Objects.requireNonNull(CacheManager.instance.getCache(this.serverId)).getMemberCache().getMemberBelongedDominions(player);
        for (MemberDTO member : playerBelongedDominionMembers) {
            if (member.getGroupId() != -1) {
                GroupDTO group = CacheManager.instance.getGroup(member.getGroupId());
                if (group == null || !group.getFlagValue(Flags.ADMIN).booleanValue()) continue;
                dominions.add(this.getDominion(member.getDomID()));
                continue;
            }
            if (!member.getFlagValue(Flags.ADMIN).booleanValue()) continue;
            dominions.add(this.getDominion(member.getDomID()));
        }
        return dominions;
    }

    @NotNull
    public List<DominionDTO> getAllDominions() {
        return new ArrayList<DominionDTO>(this.idDominions.values());
    }

    @Override
    void loadExecution() throws Exception {
        this.idDominions = new ConcurrentHashMap();
        this.dominionChildrenMap = new ConcurrentHashMap();
        this.dominionNameToId = new ConcurrentHashMap();
        this.playerOwnDominions = new ConcurrentHashMap();
        this.dominionNodeMap = new ConcurrentHashMap();
        CopyOnWriteArrayList<DominionDOO> dominions = new CopyOnWriteArrayList<DominionDOO>(DominionDOO.selectAll(this.serverId));
        dominions.forEach((Consumer<DominionDOO>)((Consumer<DominionDTO>)dominion -> this.idDominions.put(dominion.getId(), (DominionDTO)dominion)));
        CompletableFuture<Void> buildTreeFuture = this.rebuildTreeAsync();
        CompletableFuture<Void> buildCachesFuture = CompletableFuture.runAsync(() -> dominions.forEach(dominion -> {
            this.dominionNameToId.put(dominion.getName(), dominion.getId());
            this.playerOwnDominions.computeIfAbsent(dominion.getOwner(), k -> new CopyOnWriteArrayList()).add(dominion.getId());
            this.dominionChildrenMap.computeIfAbsent(dominion.getParentDomId(), k -> new CopyOnWriteArrayList()).add(dominion.getId());
        }));
        ((CompletableFuture)CompletableFuture.allOf(buildTreeFuture, buildCachesFuture).exceptionally(ex -> {
            XLogger.error(ex);
            return null;
        })).join();
    }

    @Override
    void loadExecution(Integer idToLoad) throws Exception {
        DominionDOO dominion = DominionDOO.select(idToLoad);
        if (dominion == null) {
            return;
        }
        DominionDTO oldData = this.idDominions.put(dominion.getId(), dominion);
        if (oldData != null) {
            this.dominionNameToId.entrySet().removeIf(entry -> ((Integer)entry.getValue()).equals(oldData.getId()));
            this.playerOwnDominions.computeIfAbsent(oldData.getOwner(), k -> new CopyOnWriteArrayList()).remove(oldData.getId());
            this.dominionChildrenMap.computeIfAbsent(oldData.getParentDomId(), k -> new CopyOnWriteArrayList()).remove(oldData.getId());
        }
        this.dominionNameToId.put(dominion.getName(), dominion.getId());
        this.playerOwnDominions.computeIfAbsent(dominion.getOwner(), k -> new CopyOnWriteArrayList()).add(dominion.getId());
        this.dominionChildrenMap.computeIfAbsent(dominion.getParentDomId(), k -> new CopyOnWriteArrayList()).add(dominion.getId());
        this.rebuildTreeAsync();
    }

    @Override
    void deleteExecution(Integer idToDelete) throws Exception {
        DominionDTO dominionToDelete = this.idDominions.remove(idToDelete);
        this.dominionChildrenMap.remove(idToDelete);
        if (this.dominionChildrenMap.containsKey(dominionToDelete.getParentDomId())) {
            this.dominionChildrenMap.get(dominionToDelete.getParentDomId()).remove(idToDelete);
        }
        this.dominionNameToId.entrySet().removeIf(entry -> ((Integer)entry.getValue()).equals(idToDelete));
        this.playerOwnDominions.entrySet().removeIf(entry -> ((CopyOnWriteArrayList)entry.getValue()).contains(dominionToDelete.getId()));
        this.dominionNodeMap.remove(dominionToDelete.getId());
        this.rebuildTreeAsync();
    }

    private CompletableFuture<Void> rebuildTreeAsync() {
        return CompletableFuture.runAsync(() -> {
            this.playerDominionNodes = new ConcurrentHashMap();
            CopyOnWriteArrayList<DominionNode> nodeTree = DominionNode.BuildNodeTree(-1, new CopyOnWriteArrayList<DominionDTO>(this.idDominions.values()));
            nodeTree.forEach(node -> {
                this.dominionNodeMap.put(node.getDominion().getId(), (DominionNode)node);
                this.playerDominionNodes.computeIfAbsent(node.getDominion().getOwner(), k -> new CopyOnWriteArrayList()).add(node);
            });
            this.dominionNodeSectored.build(nodeTree);
        });
    }

    public Integer count() {
        return this.idDominions.size();
    }
}

