/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.cache.server;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.cache.server.Cache;
import cn.lunadeer.dominion.doos.MemberDOO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemberCache
extends Cache {
    private final Integer serverId;
    private ConcurrentHashMap<Integer, MemberDTO> idMembers;
    private ConcurrentHashMap<Integer, CopyOnWriteArrayList<Integer>> dominionMembersMap;
    private ConcurrentHashMap<UUID, Map<Integer, Integer>> playerDominionMemberMap;
    private ConcurrentHashMap<Integer, CopyOnWriteArrayList<Integer>> groupMembersMap;

    public MemberCache(Integer serverId) {
        this.serverId = serverId;
    }

    @Nullable
    public MemberDTO getMember(@Nullable DominionDTO dominion, @NotNull Player player) {
        return this.getMember(dominion, player.getUniqueId());
    }

    @Nullable
    public MemberDTO getMember(@Nullable DominionDTO dominion, @NotNull UUID player_uuid) {
        if (dominion == null) {
            return null;
        }
        if (!this.playerDominionMemberMap.containsKey(player_uuid)) {
            return null;
        }
        Integer member_id = this.playerDominionMemberMap.get(player_uuid).get(dominion.getId());
        if (member_id == null) {
            return null;
        }
        return this.idMembers.get(member_id);
    }

    public List<MemberDTO> getMemberBelongedDominions(@NotNull UUID player) {
        if (!this.playerDominionMemberMap.containsKey(player)) {
            return new ArrayList<MemberDTO>();
        }
        Collection<Integer> member_ids = this.playerDominionMemberMap.get(player).values();
        ArrayList<MemberDTO> members = new ArrayList<MemberDTO>();
        for (Integer member_id : member_ids) {
            members.add(this.idMembers.get(member_id));
        }
        return members;
    }

    @NotNull
    public List<MemberDTO> getDominionMembers(@NotNull DominionDTO dominion) {
        if (!this.dominionMembersMap.containsKey(dominion.getId())) {
            return new ArrayList<MemberDTO>();
        }
        ArrayList<MemberDTO> members = new ArrayList<MemberDTO>();
        for (Integer member_id : this.dominionMembersMap.get(dominion.getId())) {
            members.add(this.idMembers.get(member_id));
        }
        return members;
    }

    @NotNull
    public List<MemberDTO> getGroupMembers(@NotNull GroupDTO group) {
        if (!this.groupMembersMap.containsKey(group.getId())) {
            return new ArrayList<MemberDTO>();
        }
        ArrayList<MemberDTO> members = new ArrayList<MemberDTO>();
        for (Integer member_id : this.groupMembersMap.get(group.getId())) {
            members.add(this.idMembers.get(member_id));
        }
        return members;
    }

    @Override
    void loadExecution() throws Exception {
        this.idMembers = new ConcurrentHashMap();
        this.dominionMembersMap = new ConcurrentHashMap();
        this.playerDominionMemberMap = new ConcurrentHashMap();
        this.groupMembersMap = new ConcurrentHashMap();
        List<MemberDOO> allMembers = MemberDOO.select();
        for (MemberDOO member : allMembers) {
            DominionDTO dominion = CacheManager.instance.getDominion(member.getDomID());
            if (dominion == null || !Objects.equals(dominion.getServerId(), this.serverId)) continue;
            this.idMembers.put(member.getId(), member);
            this.dominionMembersMap.computeIfAbsent(member.getDomID(), k -> new CopyOnWriteArrayList()).add(member.getId());
            this.playerDominionMemberMap.computeIfAbsent(member.getPlayerUUID(), k -> new HashMap()).put(member.getDomID(), member.getId());
            if (member.getGroupId() == -1) continue;
            this.groupMembersMap.computeIfAbsent(member.getGroupId(), k -> new CopyOnWriteArrayList()).add(member.getId());
        }
    }

    @Override
    void loadExecution(Integer idToLoad) throws Exception {
        MemberDOO member = MemberDOO.select(idToLoad);
        if (member == null) {
            return;
        }
        MemberDTO old = this.idMembers.put(member.getId(), member);
        if (old != null) {
            this.dominionMembersMap.get(old.getDomID()).remove(old.getId());
            this.playerDominionMemberMap.get(old.getPlayerUUID()).remove(old.getDomID());
            if (old.getGroupId() != -1) {
                this.groupMembersMap.get(old.getGroupId()).remove(old.getId());
            }
        }
        this.dominionMembersMap.computeIfAbsent(member.getDomID(), k -> new CopyOnWriteArrayList()).add(member.getId());
        this.playerDominionMemberMap.computeIfAbsent(member.getPlayerUUID(), k -> new HashMap()).put(member.getDomID(), member.getId());
        if (member.getGroupId() != -1) {
            this.groupMembersMap.computeIfAbsent(member.getGroupId(), k -> new CopyOnWriteArrayList()).add(member.getId());
        }
    }

    @Override
    void deleteExecution(Integer idToDelete) throws Exception {
        MemberDTO member = this.idMembers.remove(idToDelete);
        if (member == null) {
            return;
        }
        this.dominionMembersMap.get(member.getDomID()).remove(member.getId());
        this.playerDominionMemberMap.get(member.getPlayerUUID()).remove(member.getDomID());
        if (member.getGroupId() != -1) {
            this.groupMembersMap.get(member.getGroupId()).remove(member.getId());
        }
    }

    public Integer count() {
        return this.idMembers.size();
    }
}

