/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.commands;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.doos.PlayerDOO;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.misc.DominionException;
import cn.lunadeer.dominion.uis.tuis.TitleList;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import java.util.List;
import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GroupTitleCommand {
    public static SecondaryCommand useTitle = new SecondaryCommand("title_use", List.of(new CommandArguments.PlayerTitleIdArgument(), new CommandArguments.OptionalPageArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            GroupTitleCommand.useTitle(sender, this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission("dominion.default").register();

    public static void useTitle(CommandSender sender, String groupTitleIdStr, String pageStr) {
        try {
            GroupDTO group;
            PlayerDTO playerDto;
            block6: {
                Player player = Converts.toPlayer(sender);
                int titleId = Converts.toIntegrity(groupTitleIdStr);
                if (titleId == -1) {
                    ((PlayerDOO)Converts.toPlayerDTO(player.getUniqueId())).setUsingGroupTitleID(-1);
                    TitleList.show(sender, pageStr);
                    return;
                }
                playerDto = Converts.toPlayerDTO(player.getUniqueId());
                group = Converts.toGroupDTO(titleId);
                DominionDTO dominion = Converts.toDominionDTO(group.getDomID());
                try {
                    Asserts.assertDominionOwner(player, dominion);
                }
                catch (Exception e) {
                    MemberDTO member = CacheManager.instance.getMember(dominion, player);
                    if (member == null) {
                        throw new DominionException(Language.groupTitleCommandText.groupNotBelonging, group.getNamePlain());
                    }
                    if (Objects.equals(member.getGroupId(), group.getId())) break block6;
                    throw new DominionException(Language.groupTitleCommandText.groupNotBelonging, group.getNamePlain());
                }
            }
            ((PlayerDOO)playerDto).setUsingGroupTitleID(group.getId());
            Notification.info(sender, Language.groupTitleCommandText.usingTitleSuccess, group.getNamePlain());
            TitleList.show(sender, pageStr);
        }
        catch (Exception e) {
            Notification.error(sender, Language.groupTitleCommandText.usingTitleFail, e.getMessage());
        }
    }

    public static class GroupTitleCommandText
    extends ConfigurationPart {
        public String groupNotBelonging = "Don't belong to group {0}.";
        public String usingTitleSuccess = "Using title {0} successfully.";
        public String usingTitleFail = "Failed to use title, reason: {0}";
    }
}

