/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.handler;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.doos.MemberDOO;
import cn.lunadeer.dominion.events.member.MemberAddedEvent;
import cn.lunadeer.dominion.events.member.MemberRemovedEvent;
import cn.lunadeer.dominion.events.member.MemberSetFlagEvent;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.DominionException;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import java.util.Objects;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MemberEventHandler
implements Listener {
    public MemberEventHandler(JavaPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onMemberSetFlag(MemberSetFlagEvent event) {
        if (event.isCancelled()) {
            return;
        }
        try {
            DominionDTO dominion = event.getDominion();
            if (event.getFlag().equals(Flags.ADMIN)) {
                Asserts.assertDominionOwner(event.getOperator(), dominion);
            } else {
                Asserts.assertDominionAdmin(event.getOperator(), dominion);
            }
            Asserts.assertMemberBelongDominion(event.getMember(), dominion);
            MemberDTO member = event.getMember();
            if (member.getGroupId() != -1) {
                GroupDTO group = Objects.requireNonNull(CacheManager.instance.getCache(dominion.getServerId())).getGroupCache().getGroup(member.getGroupId());
                throw new DominionException(Language.memberEventHandlerText.groupAlready, group.getNamePlain());
            }
            member.setFlagValue(event.getFlag(), event.getNewValue());
            Notification.info(event.getOperator(), Language.memberEventHandlerText.setFlagSuccess, event.getFlag().getFlagName(), member.getPlayer().getLastKnownName(), dominion.getName());
        }
        catch (Exception e) {
            event.setCancelled(true);
            Notification.error(event.getOperator(), Language.memberEventHandlerText.setFlagFailed, e.getMessage());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onMemberAddEvent(MemberAddedEvent event) {
        if (event.isCancelled()) {
            return;
        }
        try {
            DominionDTO dominion = event.getDominion();
            Asserts.assertDominionAdmin(event.getOperator(), dominion);
            PlayerDTO player = event.getPlayer();
            if (player.getUuid().equals(dominion.getOwner())) {
                throw new DominionException(Language.memberEventHandlerText.cantBeOwner, new Object[0]);
            }
            if (dominion.getMembers().stream().anyMatch(m -> m.getPlayer().getUuid().equals(player.getUuid()))) {
                throw new DominionException(Language.memberEventHandlerText.alreadyMember, event.getPlayer().getLastKnownName(), dominion.getName());
            }
            MemberDOO member = MemberDOO.insert(new MemberDOO(player.getUuid(), dominion));
            event.setMember(member);
            Notification.info(event.getOperator(), Language.memberEventHandlerText.addMemberSuccess, event.getPlayer().getLastKnownName(), dominion.getName());
        }
        catch (Exception e) {
            event.setCancelled(true);
            Notification.error(event.getOperator(), Language.memberEventHandlerText.addMemberFailed, e.getMessage());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onMemberRemoveEvent(MemberRemovedEvent event) {
        if (event.isCancelled()) {
            return;
        }
        try {
            DominionDTO dominion = event.getDominion();
            Asserts.assertDominionAdmin(event.getOperator(), dominion);
            MemberDTO member = event.getMember();
            Asserts.assertMemberBelongDominion(member, dominion);
            boolean owner = false;
            try {
                Asserts.assertDominionOwner(event.getOperator(), dominion);
                owner = true;
            }
            catch (DominionException dominionException) {
                // empty catch block
            }
            GroupDTO group = Objects.requireNonNull(CacheManager.instance.getCache(dominion.getServerId())).getGroupCache().getGroup(member.getGroupId());
            if (group != null) {
                if (group.getFlagValue(Flags.ADMIN).booleanValue() && !owner) {
                    throw new DominionException(Language.groupEventHandlerText.ownerOnly, new Object[0]);
                }
            } else if (member.getFlagValue(Flags.ADMIN).booleanValue() && !owner) {
                throw new DominionException(Language.memberEventHandlerText.ownerOnly, new Object[0]);
            }
            MemberDOO.deleteById(member.getId());
            Notification.info(event.getOperator(), Language.memberEventHandlerText.removeMemberSuccess, event.getMember().getPlayer().getLastKnownName(), dominion.getName());
        }
        catch (Exception e) {
            event.setCancelled(true);
            Notification.error(event.getOperator(), Language.memberEventHandlerText.removeMemberFailed, e.getMessage());
        }
    }

    public static class MemberEventHandlerText
    extends ConfigurationPart {
        public String setFlagSuccess = "Successfully set flag {0} for {1} in {2}.";
        public String ownerOnly = "Only owner can manage admin member.";
        public String groupAlready = "This member belong to group {0} so you can't manage it separately.";
        public String setFlagFailed = "Failed to set flag, reason: {0}";
        public String addMemberSuccess = "Successfully added {0} to {1}.";
        public String alreadyMember = "{0} is already a member of {1}.";
        public String cantBeOwner = "You can't add dominion owner as a member.";
        public String addMemberFailed = "Failed to add member, reason: {0}";
        public String removeMemberSuccess = "Successfully removed {0} from {1}.";
        public String removeMemberFailed = "Failed to remove member, reason: {0}";
    }
}

