/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.misc;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.api.dtos.flag.EnvFlag;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.doos.PlayerDOO;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.utils.MessageDisplay;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.jetbrains.annotations.NotNull;

public class Others {
    public static boolean bypassLimit(Player player) {
        return player.isOp() || player.hasPermission(Dominion.adminPermission);
    }

    public static List<DominionDTO> getSubDominionsRecursive(DominionDTO dominion) {
        ArrayList<DominionDTO> res = new ArrayList<DominionDTO>();
        List<DominionDTO> sub_dominions = CacheManager.instance.getCache().getDominionCache().getChildrenOf(dominion.getId());
        for (DominionDTO sub_dominion : sub_dominions) {
            res.add(sub_dominion);
            res.addAll(Others.getSubDominionsRecursive(sub_dominion));
        }
        return res;
    }

    public static Location[] autoPoints(Player player) {
        int size = Configuration.autoCreateRadius;
        Location location = player.getLocation();
        Location location1 = new Location(location.getWorld(), location.getX() - (double)size, location.getY() - (double)size, location.getZ() - (double)size);
        Location location2 = new Location(location.getWorld(), location.getX() + (double)size, location.getY() + (double)size, location.getZ() + (double)size);
        if (Configuration.getPlayerLimitation((Player)player).getWorldSettings((World)player.getWorld()).autoIncludeVertical) {
            location1.setY((double)Configuration.getPlayerLimitation((Player)player).getWorldSettings((World)player.getWorld()).noLowerThan);
            location2.setY((double)(Configuration.getPlayerLimitation((Player)player).getWorldSettings((World)player.getWorld()).noHigherThan - 1));
        }
        return new Location[]{location1, location2};
    }

    public static void autoClean() {
        if (Configuration.autoCleanAfterDays == -1) {
            return;
        }
        XLogger.info(Language.othersText.autoCleanStart, Configuration.autoCleanAfterDays);
        int auto_clean_after_days = Configuration.autoCleanAfterDays;
        try {
            List<PlayerDTO> players = PlayerDOO.all();
            for (PlayerDTO p : players) {
                if (((PlayerDOO)p).getLastJoinAt() + (long)auto_clean_after_days * 24L * 60L * 60L * 1000L >= System.currentTimeMillis()) continue;
                try {
                    PlayerDOO.delete((PlayerDOO)p);
                }
                catch (Exception e) {
                    XLogger.error(e);
                }
                XLogger.info(Language.othersText.autoCleaningPlayer, p.getLastKnownName());
            }
        }
        catch (Exception e) {
            XLogger.error(e);
        }
        XLogger.info(Language.othersText.autoCleanEnd);
    }

    public static boolean checkPrivilegeFlag(@Nullable DominionDTO dom, @NotNull PriFlag flag, @NotNull Player player, @Nullable Cancellable event) {
        if (Others.checkPrivilegeFlagSilence(dom, flag, player, event)) {
            return true;
        }
        Object msg = Misc.formatString(Language.othersText.noPermissionForFlag, flag.getDisplayName(), flag.getDescription());
        msg = "&4&l" + (String)msg;
        MessageDisplay.show(player, MessageDisplay.Place.valueOf(Configuration.pluginMessage.noPermissionDisplayPlace.toUpperCase()), (String)msg);
        if (event != null) {
            event.setCancelled(true);
        }
        return false;
    }

    public static boolean checkPrivilegeFlagSilence(@Nullable DominionDTO dom, @NotNull PriFlag flag, @NotNull Player player, @Nullable Cancellable event) {
        if (!flag.getEnable().booleanValue()) {
            return true;
        }
        if (dom == null) {
            return true;
        }
        MemberDTO member = CacheManager.instance.getMember(dom, player);
        try {
            Asserts.assertDominionAdmin(player, dom);
            return true;
        }
        catch (Exception e) {
            if (member != null) {
                GroupDTO group = CacheManager.instance.getGroup(member.getGroupId());
                if (member.getGroupId() != -1 && group != null) {
                    return group.getFlagValue(flag);
                }
                return member.getFlagValue(flag);
            }
            return dom.getGuestPrivilegeFlagValue().get(flag);
        }
    }

    public static boolean checkEnvironmentFlag(@Nullable DominionDTO dom, @NotNull EnvFlag flag, @Nullable Cancellable event) {
        if (!flag.getEnable().booleanValue()) {
            return true;
        }
        if (dom == null) {
            return true;
        }
        if (dom.getEnvironmentFlagValue().get(flag).booleanValue()) {
            return true;
        }
        if (event != null) {
            event.setCancelled(true);
        }
        return false;
    }

    public static boolean isInDominion(@Nullable DominionDTO dominion, @NotNull Location location) {
        if (dominion == null) {
            return false;
        }
        if (!Objects.equals(dominion.getWorldUid(), location.getWorld().getUID())) {
            return false;
        }
        return dominion.getCuboid().contain(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static void lightOrNot(@NotNull Player player, @Nullable DominionDTO dominion) {
        if (!Flags.GLOW.getEnable().booleanValue()) {
            return;
        }
        if (dominion == null) {
            player.setGlowing(false);
            return;
        }
        MemberDTO member = CacheManager.instance.getCache().getMemberCache().getMember(dominion, player);
        if (member != null) {
            if (member.getGroupId() == -1) {
                player.setGlowing(member.getFlagValue(Flags.GLOW).booleanValue());
            } else {
                GroupDTO group = CacheManager.instance.getCache().getGroupCache().getGroup(member.getGroupId());
                if (group != null) {
                    player.setGlowing(group.getFlagValue(Flags.GLOW).booleanValue());
                } else {
                    player.setGlowing(dominion.getGuestPrivilegeFlagValue().get(Flags.GLOW).booleanValue());
                }
            }
        } else {
            player.setGlowing(dominion.getGuestPrivilegeFlagValue().get(Flags.GLOW).booleanValue());
        }
    }

    public static void flyOrNot(@NotNull Player player, @Nullable DominionDTO dominion) {
        for (String flyPN : Configuration.flyPermissionNodes) {
            if (!player.hasPermission(flyPN)) continue;
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (player.isOp() && Configuration.adminBypass) {
            return;
        }
        if (!Flags.FLY.getEnable().booleanValue()) {
            player.setAllowFlight(false);
            return;
        }
        if (dominion == null) {
            player.setAllowFlight(false);
            return;
        }
        MemberDTO member = CacheManager.instance.getCache().getMemberCache().getMember(dominion, player);
        if (member != null) {
            if (member.getGroupId() == -1) {
                player.setAllowFlight(member.getFlagValue(Flags.FLY).booleanValue());
            } else {
                GroupDTO group = CacheManager.instance.getCache().getGroupCache().getGroup(member.getGroupId());
                if (group != null) {
                    player.setAllowFlight(group.getFlagValue(Flags.FLY).booleanValue());
                } else {
                    player.setAllowFlight(dominion.getGuestPrivilegeFlagValue().get(Flags.FLY).booleanValue());
                }
            }
        } else {
            player.setAllowFlight(dominion.getGuestPrivilegeFlagValue().get(Flags.FLY).booleanValue());
        }
    }

    public static boolean isCrop(@NotNull Material material) {
        return material == Material.COCOA || material == Material.WHEAT || material == Material.CARROTS || material == Material.POTATOES || material == Material.BEETROOTS || material == Material.NETHER_WART || material == Material.SWEET_BERRY_BUSH || material == Material.MELON || material == Material.PUMPKIN || material == Material.SUGAR_CANE || material == Material.BAMBOO || material == Material.CACTUS || material == Material.CHORUS_PLANT || material == Material.CHORUS_FLOWER || material == Material.KELP || material == Material.KELP_PLANT;
    }

    public static boolean isExplodeEntity(@NotNull Entity entity) {
        return entity.getType() == EntityType.CREEPER || entity.getType() == EntityType.WITHER_SKULL || entity.getType() == EntityType.FIREBALL || entity.getType() == EntityType.ENDER_CRYSTAL || entity.getType() == EntityType.SMALL_FIREBALL || entity.getType() == EntityType.DRAGON_FIREBALL;
    }

    public static Location[] sortLocations(@NotNull Location location1, @NotNull Location location2) {
        int minX = Math.min(location1.getBlockX(), location2.getBlockX());
        int minY = Math.min(location1.getBlockY(), location2.getBlockY());
        int minZ = Math.min(location1.getBlockZ(), location2.getBlockZ());
        int maxX = Math.max(location1.getBlockX(), location2.getBlockX()) + 1;
        int maxY = Math.max(location1.getBlockY(), location2.getBlockY()) + 1;
        int maxZ = Math.max(location1.getBlockZ(), location2.getBlockZ()) + 1;
        return new Location[]{new Location(location1.getWorld(), (double)minX, (double)minY, (double)minZ), new Location(location1.getWorld(), (double)maxX, (double)maxY, (double)maxZ)};
    }

    public static class OthersText
    extends ConfigurationPart {
        public String autoCleanStart = "Start auto clean players who have not logged in for {0} days.";
        public String autoCleaningPlayer = "Cleaned {0}'s data.";
        public String autoCleanEnd = "Auto clean finished.";
        public String noPermissionForFlag = "You do not have {0}({1}) permission.";
    }
}

