/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.tuis;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.tuis.MainMenu;
import cn.lunadeer.dominion.uis.tuis.dominion.DominionList;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import org.bukkit.command.CommandSender;

public class AllDominion {
    public static SecondaryCommand listAll = new SecondaryCommand("list_all", List.of(new CommandArguments.OptionalPageArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            AllDominion.show(sender, this.getArgumentValue(0));
        }
    }.needPermission(Dominion.adminPermission).register();

    public static ListViewButton button(final CommandSender sender) {
        return (ListViewButton)new ListViewButton(Language.allDominionTuiText.button){

            @Override
            public void function(String pageStr) {
                AllDominion.show(sender, pageStr);
            }
        }.needPermission(Dominion.adminPermission);
    }

    public static void show(CommandSender sender, String pageStr) {
        try {
            int page = Converts.toIntegrity(pageStr);
            ListView view = ListView.create(10, AllDominion.button(sender));
            view.title(Language.allDominionTuiText.title);
            view.navigator(Line.create().append(MainMenu.button(sender).build()).append(Language.allDominionTuiText.button));
            view.addLines(DominionList.BuildTreeLines(sender, CacheManager.instance.getCache().getDominionCache().getAllDominionNodes(), 0));
            view.showOn(sender, page);
        }
        catch (Exception e) {
            Notification.error(sender, e.getMessage());
        }
    }

    public static class AllDominionTuiText
    extends ConfigurationPart {
        public String title = "All Dominions";
        public String description = "List all dominions.";
        public String button = "LIST ALL";
    }
}

