/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.tuis.dominion;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.commands.DominionOperateCommand;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.inputters.EditMessageInputter;
import cn.lunadeer.dominion.uis.inputters.RenameDominionInputter;
import cn.lunadeer.dominion.uis.inputters.SetMapColorInputter;
import cn.lunadeer.dominion.uis.tuis.MainMenu;
import cn.lunadeer.dominion.uis.tuis.dominion.DominionList;
import cn.lunadeer.dominion.uis.tuis.dominion.copy.CopyMenu;
import cn.lunadeer.dominion.uis.tuis.dominion.manage.EnvSetting;
import cn.lunadeer.dominion.uis.tuis.dominion.manage.GuestSetting;
import cn.lunadeer.dominion.uis.tuis.dominion.manage.Info;
import cn.lunadeer.dominion.uis.tuis.dominion.manage.group.GroupList;
import cn.lunadeer.dominion.uis.tuis.dominion.manage.member.MemberList;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DominionManage {
    public static SecondaryCommand manage = new SecondaryCommand("manage", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.OptionalPageArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            DominionManage.show(sender, this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static ListViewButton button(final CommandSender sender, final String dominionName) {
        return (ListViewButton)new ListViewButton(Language.dominionManageTuiText.button){

            @Override
            public void function(String pageStr) {
                DominionManage.show(sender, dominionName, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    public static void show(final CommandSender sender, final String dominionName, String pageStr) {
        try {
            Player player = Converts.toPlayer(sender);
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            Asserts.assertDominionAdmin(player, dominion);
            int page = Converts.toIntegrity(pageStr);
            Line size_info = Line.create().append(Info.button(sender, dominionName).build()).append(Language.sizeInfoTuiText.description);
            Line env_info = Line.create().append(EnvSetting.button(sender, dominionName).build()).append(Language.envSettingTuiText.description);
            Line flag_info = Line.create().append(GuestSetting.button(sender, dominionName).build()).append(Language.guestSettingTuiText.description);
            Line member_list = Line.create().append(MemberList.button(sender, dominionName).build()).append(Language.memberListTuiText.description);
            Line group_list = Line.create().append(GroupList.button(sender, dominionName).build()).append(Language.groupListTuiText.description);
            Line set_tp = Line.create().append(new FunctionalButton(Language.dominionManageTuiText.setTpButton){

                @Override
                public void function() {
                    DominionOperateCommand.setTp(sender, dominionName);
                }
            }.build()).append(Language.dominionManageTuiText.setTpDescription);
            Line rename = Line.create().append(RenameDominionInputter.createOn(sender, dominionName).needPermission(Dominion.defaultPermission).build()).append(Language.renameDominionInputterText.description);
            Line enter_msg = Line.create().append(EditMessageInputter.createEnterOn(sender, dominionName).needPermission(Dominion.defaultPermission).build()).append(Language.editMessageInputterText.enterDescription);
            Line leave_msg = Line.create().append(EditMessageInputter.createLeaveOn(sender, dominionName).needPermission(Dominion.defaultPermission).build()).append(Language.editMessageInputterText.leaveDescription);
            Line map_color = Line.create().append(SetMapColorInputter.createOn(sender, dominionName).build()).append((TextComponent)Component.text((String)Language.setMapColorInputterText.description).append((Component)Component.text((String)dominion.getColor(), (TextColor)TextColor.color((int)dominion.getColorR(), (int)dominion.getColorG(), (int)dominion.getColorB()))));
            Line copy_menu = Line.create().append(CopyMenu.button(sender, dominionName).build()).append(Language.copyMenuTuiText.description);
            ListView view = ListView.create(10, DominionManage.button(sender, dominion.getName()));
            view.title(Misc.formatString(Language.dominionManageTuiText.title, dominion.getName())).navigator(Line.create().append(MainMenu.button(sender).build()).append(DominionList.button(sender).build()).append(dominion.getName())).add(size_info).add(env_info).add(flag_info).add(member_list).add(group_list).add(set_tp).add(rename).add(enter_msg).add(leave_msg);
            if (Configuration.webMapRenderer.blueMap || Configuration.webMapRenderer.dynmap) {
                view.add(map_color);
            }
            view.add(copy_menu);
            view.showOn((CommandSender)player, page);
        }
        catch (Exception e) {
            Notification.error(sender, e.getMessage());
            XLogger.error(e);
        }
    }

    public static class DominionManageTuiText
    extends ConfigurationPart {
        public String title = "Manage {0}";
        public String button = "MANAGE";
        public String setTpButton = "SET TP";
        public String setTpDescription = "Set your current location as tp location.";
    }
}

