/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.tuis.dominion.manage;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import cn.lunadeer.dominion.commands.DominionFlagCommand;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.tuis.MainMenu;
import cn.lunadeer.dominion.uis.tuis.dominion.DominionList;
import cn.lunadeer.dominion.uis.tuis.dominion.DominionManage;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.command.CommandSender;

public class GuestSetting {
    public static ListViewButton button(final CommandSender sender, final String dominionName) {
        return (ListViewButton)new ListViewButton(Language.guestSettingTuiText.button){

            @Override
            public void function(String pageStr) {
                GuestSetting.show(sender, dominionName, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    public static void show(final CommandSender sender, final String dominionName, String pageStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            Asserts.assertDominionAdmin(sender, dominion);
            final int page = Converts.toIntegrity(pageStr);
            ListView view = ListView.create(10, GuestSetting.button(sender, dominionName));
            view.title(Misc.formatString(Language.guestSettingTuiText.title, dominion.getName())).navigator(Line.create().append(MainMenu.button(sender).build()).append(DominionList.button(sender).build()).append(DominionManage.button(sender, dominionName).build()).append(Language.guestSettingTuiText.button));
            for (final PriFlag flag : Flags.getAllPriFlagsEnable()) {
                if (flag.equals(Flags.ADMIN)) continue;
                if (dominion.getGuestFlagValue(flag)) {
                    view.add(Line.create().append(new FunctionalButton("\u2611"){

                        @Override
                        public void function() {
                            DominionFlagCommand.setGuest(sender, dominionName, flag.getFlagName(), "false", String.valueOf(page));
                        }
                    }.green().build()).append((TextComponent)Component.text((String)flag.getDisplayName()).hoverEvent((HoverEventSource)Component.text((String)flag.getDescription()))));
                    continue;
                }
                view.add(Line.create().append(new FunctionalButton("\u2610"){

                    @Override
                    public void function() {
                        DominionFlagCommand.setGuest(sender, dominionName, flag.getFlagName(), "true", String.valueOf(page));
                    }
                }.red().build()).append((TextComponent)Component.text((String)flag.getDisplayName()).hoverEvent((HoverEventSource)Component.text((String)flag.getDescription()))));
            }
            view.showOn(sender, page);
        }
        catch (Exception e) {
            Notification.error(sender, e.getMessage());
        }
    }

    public static class GuestSettingTuiText
    extends ConfigurationPart {
        public String title = "{0} Guest Setting";
        public String button = "GUEST SET";
        public String description = "Set guest behavior of dominion.";
    }
}

