/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.tuis.dominion.manage.member;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import cn.lunadeer.dominion.commands.MemberCommand;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.tuis.MainMenu;
import cn.lunadeer.dominion.uis.tuis.dominion.DominionList;
import cn.lunadeer.dominion.uis.tuis.dominion.DominionManage;
import cn.lunadeer.dominion.uis.tuis.dominion.manage.member.MemberList;
import cn.lunadeer.dominion.uis.tuis.dominion.manage.member.SelectTemplate;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.command.CommandSender;

public class MemberSetting {
    public static SecondaryCommand setting = new SecondaryCommand("member_setting", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.RequiredPlayerArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            MemberSetting.show(sender, this.getArgumentValue(0), this.getArgumentValue(1), "1");
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static ListViewButton button(final CommandSender sender, final String dominionName, final String playerName) {
        return (ListViewButton)new ListViewButton(Language.memberSettingTuiText.button){

            @Override
            public void function(String pageStr) {
                MemberSetting.show(sender, dominionName, playerName, pageStr);
            }
        }.needPermission(Dominion.defaultPermission).setHoverText(Language.memberSettingTuiText.description);
    }

    public static void show(CommandSender sender, String dominionName, String playerName, String pageStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            MemberDTO member = Converts.toMemberDTO(dominion, playerName);
            int page = Converts.toIntegrity(pageStr);
            ListView view = ListView.create(10, MemberSetting.button(sender, dominionName, playerName));
            view.title(Misc.formatString(Language.memberSettingTuiText.title, playerName));
            view.navigator(Line.create().append(MainMenu.button(sender).build()).append(DominionList.button(sender).build()).append(DominionManage.button(sender, dominionName).build()).append(MemberList.button(sender, dominionName).build()).append(Language.memberSettingTuiText.button));
            view.add(Line.create().append(SelectTemplate.button(sender, dominionName, playerName).build()));
            if (member.getFlagValue(Flags.ADMIN).booleanValue()) {
                view.add(MemberSetting.createOption(sender, Flags.ADMIN, true, playerName, dominion.getName(), page));
                view.add(MemberSetting.createOption(sender, Flags.GLOW, member.getFlagValue(Flags.GLOW), playerName, dominion.getName(), page));
            } else {
                for (PriFlag flag : Flags.getAllPriFlagsEnable()) {
                    view.add(MemberSetting.createOption(sender, flag, member.getFlagValue(flag), playerName, dominion.getName(), page));
                }
            }
            view.showOn(sender, page);
        }
        catch (Exception e) {
            Notification.error(sender, e.getMessage());
        }
    }

    private static Line createOption(final CommandSender sender, final PriFlag flag, boolean value, final String player_name, final String dominion_name, final int page) {
        if (value) {
            return Line.create().append(new FunctionalButton("\u2611"){

                @Override
                public void function() {
                    MemberCommand.setMemberPrivilege(sender, dominion_name, player_name, flag.getFlagName(), "false", String.valueOf(page));
                }
            }.needPermission(Dominion.defaultPermission).green().build()).append((TextComponent)Component.text((String)flag.getDisplayName()).hoverEvent((HoverEventSource)Component.text((String)flag.getDescription())));
        }
        return Line.create().append(new FunctionalButton("\u2610"){

            @Override
            public void function() {
                MemberCommand.setMemberPrivilege(sender, dominion_name, player_name, flag.getFlagName(), "true", String.valueOf(page));
            }
        }.needPermission(Dominion.defaultPermission).red().build()).append((TextComponent)Component.text((String)flag.getDisplayName()).hoverEvent((HoverEventSource)Component.text((String)flag.getDescription())));
    }

    public static class MemberSettingTuiText
    extends ConfigurationPart {
        public String title = "{0} Member Setting";
        public String description = "Set member's privilege of dominion.";
        public String button = "SETTING";
    }
}

