/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.tuis.dominion.manage.member;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.commands.MemberCommand;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.doos.PlayerDOO;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.inputters.SearchPlayerInputter;
import cn.lunadeer.dominion.uis.tuis.dominion.manage.member.MemberList;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import org.bukkit.command.CommandSender;

public class SelectPlayer {
    public static ListViewButton button(final CommandSender sender, final String dominionName) {
        return (ListViewButton)new ListViewButton(Language.selectPlayerTuiText.button){

            @Override
            public void function(String pageStr) {
                SelectPlayer.show(sender, dominionName, pageStr);
            }
        }.needPermission(Dominion.defaultPermission).setHoverText(Language.selectPlayerTuiText.description);
    }

    public static void show(final CommandSender sender, final String dominionName, String pageStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            Asserts.assertDominionAdmin(sender, dominion);
            int page = Converts.toIntegrity(pageStr);
            ListView view = ListView.create(10, SelectPlayer.button(sender, dominionName));
            Line sub = Line.create().append(SearchPlayerInputter.createOn(sender, dominionName).build()).append(MemberList.button(sender, dominionName).setText(Language.selectPlayerTuiText.back).build());
            view.title(Language.selectPlayerTuiText.title).subtitle(sub);
            List<PlayerDTO> players = PlayerDOO.all();
            for (final PlayerDTO p : players) {
                view.add(Line.create().append(new FunctionalButton(p.getLastKnownName()){

                    @Override
                    public void function() {
                        MemberCommand.addMember(sender, dominionName, p.getLastKnownName());
                    }
                }.needPermission(Dominion.defaultPermission).build()));
            }
            view.showOn(sender, page);
        }
        catch (Exception e) {
            Notification.error(sender, e.getMessage());
        }
    }

    public static class SelectPlayerTuiText
    extends ConfigurationPart {
        public String title = "Select Player";
        public String button = "ADD PLAYER";
        public String description = "Add a player as a member of this dominion.";
        public String back = "BACK";
    }
}

