/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.utils.Residence.Message;
import cn.lunadeer.dominion.utils.Residence.Permission;
import cn.lunadeer.dominion.utils.Residence.Residence;
import cn.lunadeer.dominion.utils.Residence.SaveFile;
import cn.lunadeer.dominion.utils.XLogger;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.java.JavaPlugin;
import org.yaml.snakeyaml.Yaml;

public class ResMigration {
    public static List<ResidenceNode> extractFromResidence(JavaPlugin plugin) {
        ArrayList<ResidenceNode> dominions = new ArrayList<ResidenceNode>();
        File resSave = new File(plugin.getDataFolder().getParent(), "Residence");
        resSave = new File(resSave, "Save");
        if (!(resSave = new File(resSave, "Worlds")).exists()) {
            XLogger.info("Residence Save not found, skipping migration");
            return dominions;
        }
        File[] files = resSave.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null || files.length == 0) {
            XLogger.info("No save files found");
            return dominions;
        }
        for (File file : files) {
            try {
                dominions.addAll(ResMigration.processWorld(file));
            }
            catch (Exception e) {
                XLogger.error("Failed to process file: {0}, {1}", file.getName(), e.getMessage());
            }
        }
        XLogger.info("Extract {0} residences", dominions.size());
        return dominions;
    }

    private static ResidenceNode parseDominion(String name, World world, Residence res, SaveFile save) {
        String[] tpLocStr;
        String[] loc = res.Areas.values().toArray()[0].toString().split(":");
        if (loc.length != 6) {
            XLogger.warn("Invalid location: " + res.Areas.get("main"));
            return null;
        }
        ResidenceNode dominionNode = new ResidenceNode();
        dominionNode.owner = UUID.fromString(res.Permissions.OwnerUUID);
        dominionNode.ownerName = res.Permissions.OwnerLastKnownName;
        dominionNode.world = world;
        dominionNode.name = name;
        dominionNode.joinMessage = save.Messages.get((Object)Integer.valueOf((int)res.Messages)).EnterMessage;
        dominionNode.leaveMessage = save.Messages.get((Object)Integer.valueOf((int)res.Messages)).LeaveMessage;
        dominionNode.loc1 = new Location(world, Double.parseDouble(loc[0]), Double.parseDouble(loc[1]), Double.parseDouble(loc[2]));
        dominionNode.loc2 = new Location(world, Double.parseDouble(loc[3]), Double.parseDouble(loc[4]), Double.parseDouble(loc[5]));
        if (res.TPLoc != null && (tpLocStr = res.TPLoc.split(":")).length >= 3) {
            dominionNode.tpLoc = new Location(world, Double.parseDouble(tpLocStr[0]), Double.parseDouble(tpLocStr[1]), Double.parseDouble(tpLocStr[2]));
        }
        if (res.Subzones != null) {
            for (Map.Entry<String, Residence> entry : res.Subzones.entrySet()) {
                ResidenceNode sub = ResMigration.parseDominion(entry.getKey(), world, entry.getValue(), save);
                if (sub == null) continue;
                dominionNode.children.add(sub);
            }
        }
        return dominionNode;
    }

    private static Map<String, Residence> parseResYml(Map<String, Object> zones) {
        HashMap<String, Residence> res = new HashMap<String, Residence>();
        for (Map.Entry<String, Object> entry : zones.entrySet()) {
            Map zone = (Map)entry.getValue();
            Residence residence = new Residence();
            if (zone.containsKey("TPLoc")) {
                residence.setTPLoc((String)zone.get("TPLoc"));
            }
            residence.setMessages((Integer)zone.get("Messages"));
            Permission permission = new Permission();
            permission.OwnerUUID = ((Map)zone.get("Permissions")).get("OwnerUUID").toString();
            permission.OwnerLastKnownName = ((Map)zone.get("Permissions")).get("OwnerLastKnownName").toString();
            residence.setPermissions(permission);
            residence.setAreas((Map)zone.get("Areas"));
            if (zone.containsKey("Subzones")) {
                residence.setSubzones(ResMigration.parseResYml((Map)zone.get("Subzones")));
            }
            res.put(entry.getKey(), residence);
        }
        return res;
    }

    private static List<ResidenceNode> processWorld(File saveFile) throws Exception {
        XLogger.debug("=====================================");
        XLogger.debug("Processing file: {0}", saveFile.getName());
        String worldName = saveFile.getName().replace("res_", "").replace(".yml", "");
        World world = Dominion.instance.getServer().getWorld(worldName);
        InputStream inputStream = Files.newInputStream(saveFile.toPath(), new OpenOption[0]);
        Map yaml = (Map)new Yaml().load(inputStream);
        SaveFile save = new SaveFile();
        Map Messages = (Map)yaml.get("Messages");
        HashMap<Integer, Message> messages = new HashMap<Integer, Message>();
        for (Map.Entry entry : Messages.entrySet()) {
            Map message = (Map)entry.getValue();
            Message msg = new Message();
            msg.EnterMessage = (String)message.get("EnterMessage");
            msg.LeaveMessage = (String)message.get("LeaveMessage");
            messages.put((Integer)entry.getKey(), msg);
        }
        save.setMessages(messages);
        Map Residences = (Map)yaml.get("Residences");
        save.Residences = ResMigration.parseResYml(Residences);
        inputStream.close();
        ArrayList<ResidenceNode> dominions = new ArrayList<ResidenceNode>();
        for (Map.Entry<String, Residence> entry : save.Residences.entrySet()) {
            String name = entry.getKey();
            Residence residence = entry.getValue();
            ResidenceNode dominion = ResMigration.parseDominion(name, world, residence, save);
            dominions.add(dominion);
        }
        return dominions;
    }

    public static class ResidenceNode {
        public UUID owner;
        public String ownerName;
        public World world;
        public String name;
        public Location loc1;
        public Location loc2;
        public Location tpLoc;
        public String joinMessage;
        public String leaveMessage;
        public List<ResidenceNode> children = new ArrayList<ResidenceNode>();
    }
}

