/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.databse;

import cn.lunadeer.dominion.utils.databse.DatabaseType;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.bukkit.plugin.java.JavaPlugin;

public class DatabaseManager {
    public static DatabaseManager instance;
    private final JavaPlugin plugin;
    private DatabaseType type;
    private final HikariConfig config = new HikariConfig();
    private DataSource ds;

    public DatabaseManager(JavaPlugin plugin, String type, String host, String port, String name, String user, String pass) throws IllegalArgumentException {
        instance = this;
        this.plugin = plugin;
        this.set(type, host, port, name, user, pass);
    }

    public void set(String type, String host, String port, String name, String user, String pass) throws IllegalArgumentException {
        try {
            this.type = DatabaseType.valueOf(type.toUpperCase());
            if (this.type.equals((Object)DatabaseType.PGSQL)) {
                this.config.setDriverClassName("org.postgresql.Driver");
                this.config.setJdbcUrl("jdbc:postgresql://" + host + ":" + port + "/" + name);
            } else if (this.type.equals((Object)DatabaseType.SQLITE)) {
                this.config.setDriverClassName("org.sqlite.JDBC");
                this.config.setJdbcUrl("jdbc:sqlite:" + String.valueOf(this.plugin.getDataFolder()) + "/" + name + ".db");
            } else if (this.type.equals((Object)DatabaseType.MYSQL)) {
                this.config.setDriverClassName("com.mysql.cj.jdbc.Driver");
                this.config.setJdbcUrl("jdbc:mysql://" + host + ":" + port + "/" + name);
            }
            this.config.setUsername(user);
            this.config.setPassword(pass);
            this.config.setMaximumPoolSize(10);
            this.config.setMinimumIdle(2);
            this.config.setIdleTimeout(60000L);
            this.config.setConnectionTimeout(30000L);
            this.config.setMaxLifetime(1800000L);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unsupported database type: " + type, e);
        }
    }

    public void reconnect() {
        if (this.ds != null) {
            this.close();
        }
        this.ds = new HikariDataSource(this.config);
    }

    public Connection getConnection() throws SQLException {
        if (this.ds == null) {
            this.reconnect();
        }
        return this.ds.getConnection();
    }

    public void close() {
        this.ds = null;
    }

    public DatabaseType getType() {
        return this.type;
    }
}

