/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.stui.inputter;

import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.stui.inputter.Inputter;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class InputterRunner {
    public static String ONLY_PLAYER = "TUI inputter can only be used by a player.";
    public static String CANCEL = " [Send 'C' to cancel the inputter.]";
    public static String INPUTTER_CANCELLED = "Inputter cancelled.";
    private Player sender;

    public InputterRunner(CommandSender sender, String hint) {
        if (!(sender instanceof Player)) {
            Notification.error(sender, ONLY_PLAYER);
            return;
        }
        Player player = (Player)sender;
        this.sender = player;
        Inputter.getInstance().register(this);
        Notification.info(sender, hint + CANCEL);
    }

    public void runner(String inputter) {
        Inputter.getInstance().unregister(this);
        try {
            if (inputter.equalsIgnoreCase("C")) {
                Notification.warn(this.sender, INPUTTER_CANCELLED);
                this.cancelRun();
            } else {
                this.run(inputter);
            }
        }
        catch (Exception e) {
            Notification.error(this.sender, e.getMessage());
            XLogger.error(e);
        }
    }

    public abstract void run(String var1);

    public void cancelRun() {
    }

    public Player getSender() {
        return this.sender;
    }
}

