/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.webMap;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.utils.scheduler.Scheduler;
import cn.lunadeer.dominion.utils.webMap.WebMapRender;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import xyz.jpenilla.squaremap.api.BukkitAdapter;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.SimpleLayerProvider;
import xyz.jpenilla.squaremap.api.Squaremap;
import xyz.jpenilla.squaremap.api.SquaremapProvider;
import xyz.jpenilla.squaremap.api.marker.Marker;
import xyz.jpenilla.squaremap.api.marker.MarkerOptions;

public class SquareMapConnect
extends WebMapRender {
    private final Squaremap api;
    private final Key MCAKey = Key.of((String)"mca_layer_key");
    private final Key dominionKey = Key.of((String)"dominion_layer_key");

    public SquareMapConnect() {
        WebMapRender.webMapInstances.add(this);
        this.api = SquaremapProvider.get();
        Bukkit.getWorlds().forEach(world -> this.api.getWorldIfEnabled(BukkitAdapter.worldIdentifier((World)world)).ifPresent(mapWorld -> {
            SimpleLayerProvider dominionProvider = SimpleLayerProvider.builder((String)"Dominion").showControls(true).build();
            mapWorld.layerRegistry().register(this.dominionKey, (Object)dominionProvider);
            SimpleLayerProvider MCAProvider = SimpleLayerProvider.builder((String)"MCA").showControls(true).build();
            mapWorld.layerRegistry().register(this.MCAKey, (Object)MCAProvider);
        }));
    }

    @Override
    protected void renderDominions(@NotNull List<DominionDTO> dominions) {
        Scheduler.runTaskAsync(() -> {
            Map<World, List<DominionDTO>> dominionMap = dominions.stream().filter(dominion -> dominion.getWorld() != null).collect(Collectors.groupingBy(DominionDTO::getWorld));
            dominionMap.forEach((world, dominionList) -> this.api.getWorldIfEnabled(BukkitAdapter.worldIdentifier((World)world)).ifPresent(mapWorld -> {
                SimpleLayerProvider dominionProvider = (SimpleLayerProvider)mapWorld.layerRegistry().get(this.dominionKey);
                dominionList.forEach(dominion -> {
                    Point p1 = Point.of((double)dominion.getCuboid().x1(), (double)dominion.getCuboid().z1());
                    Point p2 = Point.of((double)dominion.getCuboid().x2(), (double)dominion.getCuboid().z2());
                    int r = dominion.getColorR();
                    int g = dominion.getColorG();
                    int b = dominion.getColorB();
                    Marker marker = Marker.rectangle((Point)p1, (Point)p2).markerOptions(MarkerOptions.builder().fillColor(new Color(r, g, b)).fillOpacity(0.2).strokeColor(new Color(r, g, b)).strokeOpacity(0.8).build());
                    Key key = Key.of((String)("dominion_" + dominion.getId()));
                    dominionProvider.removeMarker(key);
                    dominionProvider.addMarker(key, marker);
                });
                mapWorld.layerRegistry().unregister(this.dominionKey);
                mapWorld.layerRegistry().register(this.dominionKey, (Object)dominionProvider);
            }));
        });
    }

    @Override
    protected void renderMCA(@NotNull Map<String, List<String>> mcaFiles) {
        Scheduler.runTaskAsync(() -> mcaFiles.forEach((worldName, files) -> {
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) {
                return;
            }
            this.api.getWorldIfEnabled(BukkitAdapter.worldIdentifier((World)world)).ifPresent(mapWorld -> {
                SimpleLayerProvider MCAProvider = (SimpleLayerProvider)mapWorld.layerRegistry().get(this.MCAKey);
                files.forEach(file -> {
                    String[] cords = file.split("\\.");
                    int world_x1 = Integer.parseInt(cords[1]) * 512;
                    int world_z1 = Integer.parseInt(cords[2]) * 512;
                    int world_x2 = (Integer.parseInt(cords[1]) + 1) * 512;
                    int world_z2 = (Integer.parseInt(cords[2]) + 1) * 512;
                    Point p1 = Point.of((double)world_x1, (double)world_z1);
                    Point p2 = Point.of((double)world_x2, (double)world_z2);
                    Marker marker = Marker.rectangle((Point)p1, (Point)p2).markerOptions(MarkerOptions.builder().fillColor(new Color(0, 204, 0)).fillOpacity(0.2).strokeColor(new Color(0, 204, 0)).strokeOpacity(0.8).build());
                    Key key = Key.of((String)("mca_" + worldName + "_" + cords[1] + "_" + cords[2]));
                    MCAProvider.removeMarker(key);
                    MCAProvider.addMarker(key, marker);
                });
                mapWorld.layerRegistry().unregister(this.MCAKey);
                mapWorld.layerRegistry().register(this.MCAKey, (Object)MCAProvider);
            });
        }));
    }
}

