/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.webMap;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.scheduler.Scheduler;
import cn.lunadeer.dominion.utils.webMap.BlueMapConnect;
import cn.lunadeer.dominion.utils.webMap.DynmapConnect;
import cn.lunadeer.dominion.utils.webMap.SquareMapConnect;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class WebMapRender {
    protected static List<WebMapRender> webMapInstances = new ArrayList<WebMapRender>();

    public static void WebMapRenderInit() {
        if (Configuration.webMapRenderer.dynmap) {
            try {
                new DynmapConnect();
            }
            catch (Throwable e) {
                XLogger.error(e);
            }
        }
        if (Configuration.webMapRenderer.blueMap) {
            try {
                new BlueMapConnect();
            }
            catch (Throwable e) {
                XLogger.error(e);
            }
        }
        if (Configuration.webMapRenderer.squareMap) {
            try {
                new SquareMapConnect();
            }
            catch (Throwable e) {
                XLogger.error(e);
            }
        }
        Scheduler.runTaskLaterAsync(() -> {
            for (WebMapRender mapRender : webMapInstances) {
                mapRender.renderDominions(CacheManager.instance.getCache().getDominionCache().getAllDominions());
            }
        }, (long)Configuration.webMapRenderer.refreshIntervalSeconds * 20L);
    }

    public static void renderAllMCA(@NotNull Map<String, List<String>> mcaFiles) {
        Scheduler.runTaskAsync(() -> {
            for (WebMapRender mapRender : webMapInstances) {
                mapRender.renderMCA(mcaFiles);
            }
        });
    }

    protected abstract void renderDominions(@NotNull List<DominionDTO> var1);

    protected abstract void renderMCA(@NotNull Map<String, List<String>> var1);
}

