/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.commands;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.events.group.GroupAddMemberEvent;
import cn.lunadeer.dominion.events.group.GroupCreateEvent;
import cn.lunadeer.dominion.events.group.GroupDeleteEvent;
import cn.lunadeer.dominion.events.group.GroupRemoveMemberEvent;
import cn.lunadeer.dominion.events.group.GroupRenamedEvent;
import cn.lunadeer.dominion.events.group.GroupSetFlagEvent;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.dominion.manage.group.GroupFlags;
import cn.lunadeer.dominion.uis.dominion.manage.group.GroupList;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.Argument;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import java.util.List;
import org.bukkit.command.CommandSender;

public class GroupCommand {
    public static SecondaryCommand createGroup = new SecondaryCommand("group_create", (List)List.of(new CommandArguments.RequiredDominionArgument(), new Argument("group_name", true)), Language.groupCommandText.createGroupDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            GroupCommand.createGroup(sender, this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand deleteGroup = new SecondaryCommand("group_delete", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.RequiredGroupArgument(0), new CommandArguments.OptionalPageArgument()), Language.groupCommandText.deleteGroupDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            GroupCommand.deleteGroup(sender, this.getArgumentValue(0), this.getArgumentValue(1), this.getArgumentValue(2));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand renameGroup = new SecondaryCommand("group_rename", (List)List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.RequiredGroupArgument(0), new Argument("new_group_name", true)), Language.groupCommandText.renameGroupDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            GroupCommand.renameGroup(sender, this.getArgumentValue(0), this.getArgumentValue(1), this.getArgumentValue(2));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand setGroupFlag = new SecondaryCommand("group_set_flag", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.RequiredGroupArgument(0), new CommandArguments.PriFlagArgument(), new CommandArguments.BollenOption(), new CommandArguments.OptionalPageArgument()), Language.groupCommandText.setGroupFlagDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            GroupCommand.setGroupFlag(sender, this.getArgumentValue(0), this.getArgumentValue(1), this.getArgumentValue(2), this.getArgumentValue(3), this.getArgumentValue(4));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand addMember = new SecondaryCommand("group_add_member", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.RequiredGroupArgument(0), new CommandArguments.RequiredMemberArgument(0)), Language.groupCommandText.addMemberDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            GroupCommand.addMember(sender, this.getArgumentValue(0), this.getArgumentValue(1), this.getArgumentValue(2));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand removeMember = new SecondaryCommand("group_remove_member", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.RequiredGroupArgument(0), new CommandArguments.RequiredMemberArgument(0), new CommandArguments.OptionalPageArgument()), Language.groupCommandText.removeMemberDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            GroupCommand.removeMember(sender, this.getArgumentValue(0), this.getArgumentValue(1), this.getArgumentValue(2), this.getArgumentValue(3));
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static void createGroup(CommandSender sender, String dominionName, String groupName) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            new GroupCreateEvent(sender, dominion, groupName).call();
            GroupList.show(sender, dominion.getName(), "1");
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static void deleteGroup(CommandSender sender, String dominionName, String groupName, String pageStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            GroupDTO group = Converts.toGroupDTO(dominion, groupName);
            new GroupDeleteEvent(sender, dominion, group).call();
            GroupList.show(sender, dominion.getName(), pageStr);
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static void renameGroup(CommandSender sender, String dominionName, String oldGroupName, String newGroupName) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            GroupDTO group = Converts.toGroupDTO(dominion, oldGroupName);
            new GroupRenamedEvent(sender, dominion, group, newGroupName).call();
            GroupFlags.show(sender, dominion.getName(), newGroupName, "1");
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static void setGroupFlag(CommandSender sender, String dominionName, String groupName, String flagName, String valueStr, String pageStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            GroupDTO group = Converts.toGroupDTO(dominion, groupName);
            PriFlag flag = Converts.toPriFlag(flagName);
            boolean value = Converts.toBoolean(valueStr);
            new GroupSetFlagEvent(sender, dominion, group, flag, value).call();
            GroupFlags.show(sender, dominionName, groupName, pageStr);
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static void addMember(CommandSender sender, String dominionName, String groupName, String playerName) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            MemberDTO member = Converts.toMemberDTO(dominion, playerName);
            GroupDTO group = Converts.toGroupDTO(dominion, groupName);
            new GroupAddMemberEvent(sender, dominion, group, member).call();
            GroupList.show(sender, dominion.getName(), "1");
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static void removeMember(CommandSender sender, String dominionName, String groupName, String playerName, String pageStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            GroupDTO group = Converts.toGroupDTO(dominion, groupName);
            MemberDTO member = Converts.toMemberDTO(dominion, playerName);
            new GroupRemoveMemberEvent(sender, dominion, group, member).call();
            GroupList.show(sender, dominion.getName(), pageStr);
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static class GroupCommandText
    extends ConfigurationPart {
        public String createGroupDescription = "Create a new group in a dominion.";
        public String deleteGroupDescription = "Delete a group from a dominion.";
        public String renameGroupDescription = "Rename a group in a dominion.";
        public String setGroupFlagDescription = "Set privilege flag for a group.";
        public String addMemberDescription = "Add a member to a group.";
        public String removeMemberDescription = "Remove a member from a group.";
    }
}

