/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.configuration;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.flag.Flag;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.commands.AdministratorCommand;
import cn.lunadeer.dominion.commands.CopyCommand;
import cn.lunadeer.dominion.commands.DominionCreateCommand;
import cn.lunadeer.dominion.commands.DominionFlagCommand;
import cn.lunadeer.dominion.commands.DominionOperateCommand;
import cn.lunadeer.dominion.commands.GroupCommand;
import cn.lunadeer.dominion.commands.GroupTitleCommand;
import cn.lunadeer.dominion.commands.MemberCommand;
import cn.lunadeer.dominion.commands.MigrationCommand;
import cn.lunadeer.dominion.commands.TemplateCommand;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.configuration.Limitation;
import cn.lunadeer.dominion.configuration.uis.ChestUserInterface;
import cn.lunadeer.dominion.configuration.uis.TextUserInterface;
import cn.lunadeer.dominion.handler.DominionEventHandler;
import cn.lunadeer.dominion.handler.GroupEventHandler;
import cn.lunadeer.dominion.handler.MemberEventHandler;
import cn.lunadeer.dominion.handler.SelectPointEventsHandler;
import cn.lunadeer.dominion.inputters.CreateDominionInputter;
import cn.lunadeer.dominion.inputters.CreateGroupInputter;
import cn.lunadeer.dominion.inputters.CreateTemplateInputter;
import cn.lunadeer.dominion.inputters.EditMessageInputter;
import cn.lunadeer.dominion.inputters.RenameDominionInputter;
import cn.lunadeer.dominion.inputters.RenameGroupInputter;
import cn.lunadeer.dominion.inputters.RenameTemplateInputter;
import cn.lunadeer.dominion.inputters.ResizeDominionInputter;
import cn.lunadeer.dominion.inputters.SearchPlayerInputter;
import cn.lunadeer.dominion.inputters.SetMapColorInputter;
import cn.lunadeer.dominion.managers.DatabaseTables;
import cn.lunadeer.dominion.managers.MultiServerManager;
import cn.lunadeer.dominion.managers.TeleportManager;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.misc.Others;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.VaultConnect.VaultConnect;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.command.InvalidArgumentException;
import cn.lunadeer.dominion.utils.command.NoPermissionException;
import cn.lunadeer.dominion.utils.configuration.ConfigurationFile;
import cn.lunadeer.dominion.utils.configuration.ConfigurationManager;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.configuration.HandleManually;
import cn.lunadeer.dominion.utils.configuration.Headers;
import cn.lunadeer.dominion.utils.configuration.PostProcess;
import cn.lunadeer.dominion.utils.configuration.PreProcess;
import cn.lunadeer.dominion.utils.stui.inputter.InputterRunner;
import cn.lunadeer.dominion.utils.webMap.BlueMapConnect;
import cn.lunadeer.dominion.utils.webMap.DynmapConnect;
import java.io.File;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;

@Headers(value={"Language file for Dominion plugin", "If you want to help translate this file, please refer to:", "https://dominion.lunadeer.cn/en/notes/doc/owner/config-ref/languages", "for more instructions.", "", "Most of the text support color codes,", "you can use \u00a70-\u00a79 for colors, \u00a7l for bold, \u00a7o for italic, \u00a7n for underline, \u00a7m for strikethrough, and \u00a7k for magic.", "Also support '&' as an alternative for '\u00a7'."})
public class Language
extends ConfigurationFile {
    public static Dominion.DominionText dominionText = new Dominion.DominionText();
    public static AbstractUI.ConsoleText consoleText = new AbstractUI.ConsoleText();
    public static AbstractUI.UiCommandsDescription uiCommandsDescription = new AbstractUI.UiCommandsDescription();
    public static MultiServerManager.MultiServerManagerText multiServerManagerText = new MultiServerManager.MultiServerManagerText();
    public static Asserts.AssertsText assertsText = new Asserts.AssertsText();
    public static Converts.ConvertsText convertsText = new Converts.ConvertsText();
    public static Others.OthersText othersText = new Others.OthersText();
    public static VaultConnect.VaultConnectText vaultConnectText = new VaultConnect.VaultConnectText();
    public static DominionEventHandler.DominionEventHandlerText dominionEventHandlerText = new DominionEventHandler.DominionEventHandlerText();
    public static MemberEventHandler.MemberEventHandlerText memberEventHandlerText = new MemberEventHandler.MemberEventHandlerText();
    public static GroupEventHandler.GroupEventHandlerText groupEventHandlerText = new GroupEventHandler.GroupEventHandlerText();
    public static SelectPointEventsHandler.SelectPointEventsHandlerText selectPointEventsHandlerText = new SelectPointEventsHandler.SelectPointEventsHandlerText();
    public static CreateDominionInputter.CreateDominionInputterText createDominionInputterText = new CreateDominionInputter.CreateDominionInputterText();
    public static CreateGroupInputter.CreateGroupInputterText createGroupInputterText = new CreateGroupInputter.CreateGroupInputterText();
    public static RenameDominionInputter.RenameDominionInputterText renameDominionInputterText = new RenameDominionInputter.RenameDominionInputterText();
    public static EditMessageInputter.EditMessageInputterText editMessageInputterText = new EditMessageInputter.EditMessageInputterText();
    public static CreateTemplateInputter.CreateTemplateInputterText createTemplateInputterText = new CreateTemplateInputter.CreateTemplateInputterText();
    public static RenameGroupInputter.RenameGroupInputterText renameGroupInputterText = new RenameGroupInputter.RenameGroupInputterText();
    public static ResizeDominionInputter.ResizeDominionInputterText resizeDominionInputterText = new ResizeDominionInputter.ResizeDominionInputterText();
    public static SearchPlayerInputter.SearchPlayerInputterText searchPlayerInputterText = new SearchPlayerInputter.SearchPlayerInputterText();
    public static SetMapColorInputter.SetMapColorInputterText setMapColorInputterText = new SetMapColorInputter.SetMapColorInputterText();
    public static RenameTemplateInputter.RenameTemplateInputterText renameTemplateInputterText = new RenameTemplateInputter.RenameTemplateInputterText();
    public static AdministratorCommand.AdministratorCommandText administratorCommandText = new AdministratorCommand.AdministratorCommandText();
    public static MigrationCommand.MigrationCommandText migrationCommandText = new MigrationCommand.MigrationCommandText();
    public static TemplateCommand.TemplateCommandText templateCommandText = new TemplateCommand.TemplateCommandText();
    public static GroupTitleCommand.GroupTitleCommandText groupTitleCommandText = new GroupTitleCommand.GroupTitleCommandText();
    public static CopyCommand.CopyCommandText copyCommandText = new CopyCommand.CopyCommandText();
    public static DominionOperateCommand.DominionOperateCommandText dominionOperateCommandText = new DominionOperateCommand.DominionOperateCommandText();
    public static DominionCreateCommand.DominionCreateCommandText dominionCreateCommandText = new DominionCreateCommand.DominionCreateCommandText();
    public static DominionFlagCommand.DominionFlagCommandText dominionFlagCommandText = new DominionFlagCommand.DominionFlagCommandText();
    public static GroupCommand.GroupCommandText groupCommandText = new GroupCommand.GroupCommandText();
    public static MemberCommand.MemberCommandText memberCommandText = new MemberCommand.MemberCommandText();
    public static Configuration.ConfigurationText configurationText = new Configuration.ConfigurationText();
    public static Limitation.LimitationText limitationText = new Limitation.LimitationText();
    public static DatabaseTables.DatabaseManagerText databaseManagerText = new DatabaseTables.DatabaseManagerText();
    public static TeleportManager.TeleportManagerText teleportManagerText = new TeleportManager.TeleportManagerText();
    public static BlueMapConnect.BlueMapConnectText blueMapConnectText = new BlueMapConnect.BlueMapConnectText();
    public static DynmapConnect.DynmapConnectText dynmapConnectText = new DynmapConnect.DynmapConnectText();
    public static CommandExceptionText commandExceptionText = new CommandExceptionText();
    public static InputterText inputterText = new InputterText();

    public static void loadLanguageFiles(CommandSender sender, JavaPlugin plugin, String code) {
        try {
            File languagesFolder = new File(Dominion.instance.getDataFolder(), "languages");
            File cuiFolder = new File(languagesFolder, "cui");
            File tuiFolder = new File(languagesFolder, "tui");
            for (LanguageCode languageCode : LanguageCode.values()) {
                Language.updateLanguageFiles(plugin, languageCode.name(), false);
            }
            Notification.info((CommandSender)(sender != null ? sender : Dominion.instance.getServer().getConsoleSender()), Language.configurationText.loadingLanguage, code);
            ConfigurationManager.load(Language.class, new File(languagesFolder, code + ".yml"));
            ConfigurationManager.load(ChestUserInterface.class, new File(cuiFolder, code + ".yml"));
            ConfigurationManager.load(TextUserInterface.class, new File(tuiFolder, code + ".yml"));
            Notification.info((CommandSender)(sender != null ? sender : Dominion.instance.getServer().getConsoleSender()), Language.configurationText.loadLanguageSuccess, code);
        }
        catch (Exception e) {
            Notification.error((CommandSender)(sender != null ? sender : Dominion.instance.getServer().getConsoleSender()), Language.configurationText.loadLanguageFail, code, e.getMessage());
        }
    }

    public static void updateLanguageFiles(JavaPlugin plugin, String code, boolean overwrite) {
        File tuiFolder;
        File cuiFolder;
        File languagesFolder = new File(plugin.getDataFolder(), "languages");
        if (!languagesFolder.exists()) {
            languagesFolder.mkdir();
        }
        if (!(cuiFolder = new File(languagesFolder, "cui")).exists()) {
            cuiFolder.mkdir();
        }
        if (!(tuiFolder = new File(languagesFolder, "tui")).exists()) {
            tuiFolder.mkdir();
        }
        if (!new File(languagesFolder, code + ".yml").exists()) {
            try {
                Dominion.instance.saveResource("languages/" + code + ".yml", overwrite);
            }
            catch (Exception e) {
                XLogger.warn("Failed to save language file for {0}, This language may not in official repo : {1}.", code, e.getMessage());
                XLogger.warn("See https://dominion.lunadeer.cn/en/notes/doc/owner/config-ref/languages , If you want to help us to add this language.");
            }
        }
        if (!new File(cuiFolder, code + ".yml").exists()) {
            try {
                Dominion.instance.saveResource("languages/cui/" + code + ".yml", overwrite);
            }
            catch (Exception e) {
                XLogger.warn("Failed to save CUI language file for {0}, This language may not in official repo : {1}.", code, e.getMessage());
                XLogger.warn("See https://dominion.lunadeer.cn/en/notes/doc/owner/config-ref/languages , If you want to help us to add this language.");
            }
        }
        if (!new File(tuiFolder, code + ".yml").exists()) {
            try {
                Dominion.instance.saveResource("languages/tui/" + code + ".yml", overwrite);
            }
            catch (Exception e) {
                XLogger.warn("Failed to save TUI language file for {0}, This language may not in official repo : {1}.", code, e.getMessage());
                XLogger.warn("See https://dominion.lunadeer.cn/en/notes/doc/owner/config-ref/languages , If you want to help us to add this language.");
            }
        }
    }

    @PreProcess
    public void loadFlagsText() {
        for (Flag flag : Flags.getAllFlags()) {
            if (this.getYaml().contains(flag.getDisplayNameKey())) {
                flag.setDisplayName(this.getYaml().getString(flag.getDisplayNameKey()));
            } else {
                this.getYaml().set(flag.getDisplayNameKey(), (Object)flag.getDisplayName());
            }
            if (this.getYaml().contains(flag.getDescriptionKey())) {
                flag.setDescription(this.getYaml().getString(flag.getDescriptionKey()));
                continue;
            }
            this.getYaml().set(flag.getDescriptionKey(), (Object)flag.getDescription());
        }
    }

    @PostProcess
    public static void setOtherStaticText() {
        InvalidArgumentException.MSG = Language.commandExceptionText.invalidArguments;
        NoPermissionException.MSG = Language.commandExceptionText.noPermission;
        InputterRunner.ONLY_PLAYER = Language.inputterText.onlyPlayer;
        InputterRunner.CANCEL = Language.inputterText.cancel;
        InputterRunner.INPUTTER_CANCELLED = Language.inputterText.inputterCancelled;
    }

    @HandleManually
    public static enum LanguageCode {
        en_us,
        zh_cn,
        jp_jp,
        zh_tw;

    }

    public static class CommandExceptionText
    extends ConfigurationPart {
        public String noPermission = "You do not have permission {0} to do this.";
        public String invalidArguments = "Invalid arguments, usage e.g. {0}.";
    }

    public static class InputterText
    extends ConfigurationPart {
        public String onlyPlayer = "TUI inputter can only be used by a player.";
        public String cancel = " [Send 'C' to cancel the inputter.]";
        public String inputterCancelled = "Inputter cancelled.";
    }
}

