/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.scui;

import cn.lunadeer.dominion.utils.ColorParser;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ChestView {
    private final Player viewOwner;
    private String title;
    protected final Map<Integer, ChestButton> buttons = new HashMap<Integer, ChestButton>();
    private String layout = "";

    public ChestView(@NotNull Player viewOwner) {
        this.viewOwner = viewOwner;
        this.title = "Default Title";
        ChestUserInterfaceManager.getInstance().registerView(this);
    }

    public ChestView setLayout(@NotNull List<String> layout) {
        StringBuilder builder = new StringBuilder();
        if (layout.isEmpty()) {
            throw new IllegalArgumentException("Layout cannot be empty.");
        }
        for (String row : layout) {
            builder.append(row);
        }
        return this.setLayout(builder.toString());
    }

    public ChestView setLayout(String ... layout) {
        return this.setLayout(String.join((CharSequence)"", layout));
    }

    public ChestView setLayout(@NotNull String layout) {
        if (layout.isEmpty()) {
            throw new IllegalArgumentException("Layout cannot be empty.");
        }
        if (layout.length() % 9 != 0) {
            throw new IllegalArgumentException("Layout must be a multiple of 9 characters.");
        }
        if (layout.length() / 9 > 6) {
            throw new IllegalArgumentException("Layout cannot have more than 6 rows.");
        }
        this.layout = layout;
        return this;
    }

    public ChestView setTitle(@NotNull String title) {
        if (title.isEmpty()) {
            throw new IllegalArgumentException("Title cannot be null or empty.");
        }
        this.title = title;
        return this;
    }

    public ChestView clearButtons() {
        this.buttons.clear();
        return this;
    }

    public ChestView clearLayout() {
        this.layout = "";
        return this;
    }

    public ChestView setButton(char symbol, @NotNull ChestButton button) {
        if (this.layout.isEmpty()) {
            throw new IllegalStateException("Layout must be set before adding buttons with symbols.");
        }
        for (int i = 0; i < this.layout.length(); ++i) {
            if (this.layout.charAt(i) != symbol) continue;
            this.setButton(i, button);
        }
        return this;
    }

    public ChestView setButton(int slot, @NotNull ChestButton button) {
        if (slot < 0 || slot >= 54) {
            throw new IllegalArgumentException("Slot must be between 0 and 53.");
        }
        this.buttons.put(slot, button);
        return this;
    }

    public ChestView setButton(int row, int column, @NotNull ChestButton button) {
        if (row < 0 || row >= 6 || column < 0 || column >= 9) {
            throw new IllegalArgumentException("Row must be between 0 and 5 and column must be between 0 and 8.");
        }
        return this.setButton(row * 9 + column, button);
    }

    public ChestView setButtons(@NotNull Map<Integer, ChestButton> buttons) {
        for (Map.Entry<Integer, ChestButton> entry : buttons.entrySet()) {
            this.setButton(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public ChestView removeButton(int slot) {
        this.buttons.remove(slot);
        return this;
    }

    public void open() {
        ItemStack firstItem = this.viewOwner.getOpenInventory().getItem(0);
        if (ChestUserInterfaceManager.hasTag(firstItem) && this.viewOwner.getOpenInventory().countSlots() == (this.layout.isEmpty() ? 54 : this.layout.length())) {
            this.refresh(this.viewOwner.getOpenInventory());
        } else {
            this.create();
        }
    }

    public void close() {
        ItemStack firstItem = this.viewOwner.getOpenInventory().getItem(0);
        if (ChestUserInterfaceManager.hasTag(firstItem)) {
            this.viewOwner.getOpenInventory().close();
        }
    }

    protected void create() {
        Inventory view = Bukkit.createInventory((InventoryHolder)this.viewOwner, (int)(this.layout.isEmpty() ? 54 : this.layout.length()), (String)"");
        InventoryView inventoryView = this.viewOwner.openInventory(view);
        if (inventoryView == null) {
            throw new IllegalStateException("Failed to open inventory for player: " + this.viewOwner.getName());
        }
        this.refresh(inventoryView);
    }

    protected void refresh(@NotNull InventoryView view) {
        try {
            this.title = Misc.setPlaceholder(this.viewOwner, this.title);
            this.title = ColorParser.getBukkitType(this.title);
            view.setTitle(this.title);
            for (Map.Entry<Integer, ChestButton> entry : this.buttons.entrySet()) {
                int slot = entry.getKey();
                ChestButton button = entry.getValue();
                if (button != null) {
                    ItemStack item = ChestUserInterfaceManager.attachTag(this.viewOwner.getUniqueId(), button.build(this.viewOwner));
                    view.setItem(slot, item);
                    continue;
                }
                view.setItem(slot, null);
            }
            int totalSlots = this.layout.isEmpty() ? 54 : this.layout.length();
            for (int i = 0; i < totalSlots; ++i) {
                if (view.getItem(i) != null) continue;
                view.setItem(i, ChestUserInterfaceManager.PLACE_HOLDER_ITEM);
            }
        }
        catch (Exception e) {
            view.close();
            Notification.error((CommandSender)this.viewOwner, e);
        }
    }

    public UUID getViewId() {
        return this.viewOwner.getUniqueId();
    }

    public Player getViewOwner() {
        return this.viewOwner;
    }

    public String getTitle() {
        return this.title;
    }

    public String getLayout() {
        return this.layout;
    }

    public void handleClick(Integer slot, ClickType type) {
        ChestButton button = this.buttons.get(slot);
        if (button != null) {
            button.onClick(type);
        } else {
            this.viewOwner.sendMessage("\u00a7cNo action assigned to this slot.");
        }
    }
}

