/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.cache;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.cache.DominionNode;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.utils.AutoTimer;
import cn.lunadeer.dominion.utils.XLogger;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public class DominionNodeSectored {
    private volatile ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> world_dominion_tree_sector_a;
    private volatile ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> world_dominion_tree_sector_b;
    private volatile ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> world_dominion_tree_sector_c;
    private volatile ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> world_dominion_tree_sector_d;
    private volatile Integer section_origin_x = 0;
    private volatile Integer section_origin_z = 0;

    public DominionDTO getDominionByLocation(@NotNull Location loc) {
        try (AutoTimer ignored = new AutoTimer(Configuration.timer);){
            CopyOnWriteArrayList<DominionNode> nodes = this.getNodes(loc);
            if (nodes == null) {
                DominionDTO dominionDTO = null;
                return dominionDTO;
            }
            if (nodes.isEmpty()) {
                DominionDTO dominionDTO = null;
                return dominionDTO;
            }
            DominionNode dominionNode = DominionNode.getDominionNodeByLocation(nodes, loc);
            DominionDTO dominionDTO = dominionNode == null ? null : dominionNode.getDominion();
            return dominionDTO;
        }
    }

    public CopyOnWriteArrayList<DominionNode> getNodes(@NotNull Location loc) {
        return this.getNodes(loc.getWorld().getUID(), loc.getBlockX(), loc.getBlockZ());
    }

    public CopyOnWriteArrayList<DominionNode> getNodes(World world, int x, int z) {
        return this.getNodes(world.getUID(), x, z);
    }

    public CopyOnWriteArrayList<DominionNode> getNodes(UUID world, int x, int z) {
        ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> sectorA = this.world_dominion_tree_sector_a;
        ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> sectorB = this.world_dominion_tree_sector_b;
        ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> sectorC = this.world_dominion_tree_sector_c;
        ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> sectorD = this.world_dominion_tree_sector_d;
        int originX = this.section_origin_x;
        int originZ = this.section_origin_z;
        if (x >= originX && z >= originZ) {
            if (sectorA == null) {
                return null;
            }
            return sectorA.get(world);
        }
        if (x <= originX && z >= originZ) {
            if (sectorB == null) {
                return null;
            }
            return sectorB.get(world);
        }
        if (x >= originX) {
            if (sectorC == null) {
                return null;
            }
            return sectorC.get(world);
        }
        if (sectorD == null) {
            return null;
        }
        return sectorD.get(world);
    }

    public CompletableFuture<Void> buildAsync(CopyOnWriteArrayList<DominionNode> nodes) {
        return CompletableFuture.runAsync(() -> {
            try (AutoTimer ignored = new AutoTimer(Configuration.timer);){
                ConcurrentHashMap tempSectorA = new ConcurrentHashMap();
                ConcurrentHashMap tempSectorB = new ConcurrentHashMap();
                ConcurrentHashMap tempSectorC = new ConcurrentHashMap();
                ConcurrentHashMap tempSectorD = new ConcurrentHashMap();
                int max_x = nodes.parallelStream().mapToInt(n -> n.getDominion().getCuboid().x2()).max().orElse(0);
                int min_x = nodes.parallelStream().mapToInt(n -> n.getDominion().getCuboid().x1()).min().orElse(0);
                int max_z = nodes.parallelStream().mapToInt(n -> n.getDominion().getCuboid().z2()).max().orElse(0);
                int min_z = nodes.parallelStream().mapToInt(n -> n.getDominion().getCuboid().z1()).min().orElse(0);
                int tempOriginX = (max_x + min_x) / 2;
                int tempOriginZ = (max_z + min_z) / 2;
                XLogger.debug("Cache init section origin: {0}, {1}", tempOriginX, tempOriginZ);
                nodes.parallelStream().forEach(n -> {
                    DominionDTO d = n.getDominion();
                    tempSectorA.computeIfAbsent(d.getWorldUid(), k -> new CopyOnWriteArrayList());
                    tempSectorB.computeIfAbsent(d.getWorldUid(), k -> new CopyOnWriteArrayList());
                    tempSectorC.computeIfAbsent(d.getWorldUid(), k -> new CopyOnWriteArrayList());
                    tempSectorD.computeIfAbsent(d.getWorldUid(), k -> new CopyOnWriteArrayList());
                    this.placeDominionInSectors((DominionNode)n, d, tempOriginX, tempOriginZ, tempSectorA, tempSectorB, tempSectorC, tempSectorD);
                });
                DominionNodeSectored dominionNodeSectored = this;
                synchronized (dominionNodeSectored) {
                    this.world_dominion_tree_sector_a = tempSectorA;
                    this.world_dominion_tree_sector_b = tempSectorB;
                    this.world_dominion_tree_sector_c = tempSectorC;
                    this.world_dominion_tree_sector_d = tempSectorD;
                    this.section_origin_x = tempOriginX;
                    this.section_origin_z = tempOriginZ;
                }
            }
        }, ForkJoinPool.commonPool());
    }

    private void placeDominionInSectors(DominionNode n, DominionDTO d, int tempOriginX, int tempOriginZ, ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> tempSectorA, ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> tempSectorB, ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> tempSectorC, ConcurrentHashMap<UUID, CopyOnWriteArrayList<DominionNode>> tempSectorD) {
        if (d.getCuboid().x1() >= tempOriginX && d.getCuboid().z1() >= tempOriginZ) {
            tempSectorA.get(d.getWorldUid()).add(n);
        } else if (d.getCuboid().x1() <= tempOriginX && d.getCuboid().z1() >= tempOriginZ) {
            if (d.getCuboid().x2() >= tempOriginX) {
                tempSectorA.get(d.getWorldUid()).add(n);
                tempSectorB.get(d.getWorldUid()).add(n);
            } else {
                tempSectorB.get(d.getWorldUid()).add(n);
            }
        } else if (d.getCuboid().x1() >= tempOriginX && d.getCuboid().z1() <= tempOriginZ) {
            if (d.getCuboid().z2() >= tempOriginZ) {
                tempSectorA.get(d.getWorldUid()).add(n);
                tempSectorC.get(d.getWorldUid()).add(n);
            } else {
                tempSectorC.get(d.getWorldUid()).add(n);
            }
        } else if (d.getCuboid().x2() >= tempOriginX && d.getCuboid().z2() >= tempOriginZ) {
            tempSectorA.get(d.getWorldUid()).add(n);
            tempSectorB.get(d.getWorldUid()).add(n);
            tempSectorC.get(d.getWorldUid()).add(n);
            tempSectorD.get(d.getWorldUid()).add(n);
        } else if (d.getCuboid().x2() >= tempOriginX && d.getCuboid().z2() <= tempOriginZ) {
            tempSectorC.get(d.getWorldUid()).add(n);
            tempSectorD.get(d.getWorldUid()).add(n);
        } else if (d.getCuboid().z2() >= tempOriginZ && d.getCuboid().x2() <= tempOriginX) {
            tempSectorB.get(d.getWorldUid()).add(n);
            tempSectorD.get(d.getWorldUid()).add(n);
        } else {
            tempSectorD.get(d.getWorldUid()).add(n);
        }
    }
}

