/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.dominion.copy;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.configuration.uis.ChestUserInterface;
import cn.lunadeer.dominion.configuration.uis.TextUserInterface;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.MainMenu;
import cn.lunadeer.dominion.uis.dominion.DominionList;
import cn.lunadeer.dominion.uis.dominion.DominionManage;
import cn.lunadeer.dominion.uis.dominion.copy.DominionCopy;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.ChestView;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class CopyMenu
extends AbstractUI {
    public static void show(CommandSender sender, String toDominionName, String pageStr) {
        new CopyMenu().displayByPreference(sender, toDominionName, pageStr);
    }

    public static ListViewButton button(final CommandSender sender, final String toDominionName) {
        return (ListViewButton)new ListViewButton(TextUserInterface.copyMenuTuiText.button){

            @Override
            public void function(String pageStr) {
                CopyMenu.show(sender, toDominionName, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    @Override
    protected void showTUI(Player player, String ... args) throws Exception {
        String toDominionName = args[0];
        DominionDTO dominion = Converts.toDominionDTO(toDominionName);
        Asserts.assertDominionAdmin(player, dominion);
        int page = Converts.toIntegrity(args[1]);
        ListView view = ListView.create(10, CopyMenu.button((CommandSender)player, toDominionName));
        view.title(Misc.formatString(TextUserInterface.copyMenuTuiText.title, new Object[0]));
        view.navigator(Line.create().append(MainMenu.button((CommandSender)player).build()).append(DominionList.button((CommandSender)player).build()).append(DominionManage.button((CommandSender)player, toDominionName).build()).append(TextUserInterface.copyMenuTuiText.button));
        view.add(Line.create().append(DominionCopy.button(player, toDominionName, DominionCopy.CopyType.ENVIRONMENT).build()).append(TextUserInterface.dominionCopyTuiText.envDescription));
        view.add(Line.create().append(DominionCopy.button(player, toDominionName, DominionCopy.CopyType.GUEST).build()).append(TextUserInterface.dominionCopyTuiText.guestDescription));
        view.add(Line.create().append(DominionCopy.button(player, toDominionName, DominionCopy.CopyType.MEMBER).build()).append(TextUserInterface.dominionCopyTuiText.memberDescription));
        view.add(Line.create().append(DominionCopy.button(player, toDominionName, DominionCopy.CopyType.GROUP).build()).append(TextUserInterface.dominionCopyTuiText.groupDescription));
        view.showOn(player, page);
    }

    @Override
    protected void showCUI(final Player player, String ... args) throws Exception {
        final String toDominionName = args[0];
        DominionDTO dominion = Converts.toDominionDTO(toDominionName);
        Asserts.assertDominionAdmin(player, dominion);
        ChestView view = ChestUserInterfaceManager.getInstance().getViewOf(player);
        view.setTitle(ChestUserInterface.copyMenuCui.title);
        view.setLayout(ChestUserInterface.copyMenuCui.layout);
        view.setButton(ChestUserInterface.copyMenuCui.backButton.getSymbol(), new ChestButton(ChestUserInterface.copyMenuCui.backButton){

            @Override
            public void onClick(ClickType type) {
                DominionManage.show((CommandSender)player, toDominionName, "1");
            }
        });
        view.setButton(ChestUserInterface.copyMenuCui.envCopyButton.getSymbol(), new ChestButton(ChestUserInterface.copyMenuCui.envCopyButton){

            @Override
            public void onClick(ClickType type) {
                DominionCopy.show((CommandSender)player, toDominionName, DominionCopy.CopyType.ENVIRONMENT, "1");
            }
        });
        view.setButton(ChestUserInterface.copyMenuCui.guestCopyButton.getSymbol(), new ChestButton(ChestUserInterface.copyMenuCui.guestCopyButton){

            @Override
            public void onClick(ClickType type) {
                DominionCopy.show((CommandSender)player, toDominionName, DominionCopy.CopyType.GUEST, "1");
            }
        });
        view.setButton(ChestUserInterface.copyMenuCui.memberCopyButton.getSymbol(), new ChestButton(ChestUserInterface.copyMenuCui.memberCopyButton){

            @Override
            public void onClick(ClickType type) {
                DominionCopy.show((CommandSender)player, toDominionName, DominionCopy.CopyType.MEMBER, "1");
            }
        });
        view.setButton(ChestUserInterface.copyMenuCui.groupCopyButton.getSymbol(), new ChestButton(ChestUserInterface.copyMenuCui.groupCopyButton){

            @Override
            public void onClick(ClickType type) {
                DominionCopy.show((CommandSender)player, toDominionName, DominionCopy.CopyType.GROUP, "1");
            }
        });
        view.open();
    }

    @Override
    protected void showConsole(CommandSender sender, String ... args) throws Exception {
        Notification.warn(sender, Language.consoleText.inGameOnly);
    }

    public static class CopyMenuTuiText
    extends ConfigurationPart {
        public String button = "COPY";
        public String description = "Copy Privilege Settings From Other Dominion.";
        public String title = "Select Copy Type";
    }

    public static class CopyMenuCui
    extends ConfigurationPart {
        public String title = "\u00a76\u2726 \u00a7a\u00a7lCopy Settings \u00a76\u2726";
        public List<String> layout = List.of("<########", "#E#G#M#P#", "#########");
        public ButtonConfiguration backButton = ButtonConfiguration.createMaterial('<', Material.RED_STAINED_GLASS_PANE, "\u00a7c\u00ab Back to Dominion Management", List.of("\u00a77Return to dominion management", "\u00a77to access other settings.", "", "\u00a7e\u25b6 Click to go back"));
        public ButtonConfiguration envCopyButton = ButtonConfiguration.createMaterial('E', Material.GRASS_BLOCK, "\u00a72\ud83c\udf0d \u00a7aEnvironment Copy", List.of("\u00a77Copy environment settings", "\u00a77from another dominion.", "", "\u00a7a\u25b6 Click to copy environment", "", "\u00a78Weather, time, mob spawning..."));
        public ButtonConfiguration guestCopyButton = ButtonConfiguration.createMaterial('G', Material.OAK_DOOR, "\u00a7e\ud83d\udeaa \u00a76Guest Copy", List.of("\u00a77Copy guest permissions", "\u00a77from another dominion.", "", "\u00a76\u25b6 Click to copy guest settings", "", "\u00a78Build, interact, use items..."));
        public ButtonConfiguration memberCopyButton = ButtonConfiguration.createMaterial('M', Material.PLAYER_HEAD, "\u00a7b\ud83d\udc65 \u00a73Member Copy", List.of("\u00a77Copy member permissions", "\u00a77from another dominion.", "", "\u00a73\u25b6 Click to copy member settings", "", "\u00a78Individual player permissions..."));
        public ButtonConfiguration groupCopyButton = ButtonConfiguration.createMaterial('P', Material.CHEST, "\u00a7d\ud83d\udce6 \u00a75Group Copy", List.of("\u00a77Copy group settings", "\u00a77from another dominion.", "", "\u00a75\u25b6 Click to copy group settings", "", "\u00a78Permission groups and roles..."));
    }
}

