/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.cache;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.cache.server.DominionCache;
import cn.lunadeer.dominion.cache.server.PlayerCache;
import cn.lunadeer.dominion.cache.server.ResidenceDataCache;
import cn.lunadeer.dominion.cache.server.ServerCache;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.doos.DominionDOO;
import cn.lunadeer.dominion.doos.PlayerDOO;
import cn.lunadeer.dominion.events.PlayerCrossDominionBorderEvent;
import cn.lunadeer.dominion.events.PlayerMoveInDominionEvent;
import cn.lunadeer.dominion.events.PlayerMoveOutDominionEvent;
import cn.lunadeer.dominion.handler.CacheEventHandler;
import cn.lunadeer.dominion.misc.Others;
import cn.lunadeer.dominion.utils.AutoTimer;
import cn.lunadeer.dominion.utils.XLogger;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class CacheManager {
    private final ServerCache thisServerCache;
    private final ConcurrentHashMap<Integer, ServerCache> otherServerCaches;
    private final PlayerCache playerCache;
    private final ResidenceDataCache residenceDataCache = new ResidenceDataCache();
    private boolean recheckPlayerStatus = false;
    private final ConcurrentHashMap<UUID, Integer> playerCurrentDominionId = new ConcurrentHashMap();
    public static CacheManager instance;
    public static final Long UPDATE_INTERVAL;

    public CacheManager() {
        instance = this;
        this.playerCache = new PlayerCache();
        this.playerCache.load();
        this.thisServerCache = new ServerCache(Configuration.multiServer.serverId);
        this.thisServerCache.getDominionCache().load();
        this.thisServerCache.getMemberCache().load();
        this.thisServerCache.getGroupCache().load();
        this.otherServerCaches = new ConcurrentHashMap();
        Bukkit.getPluginManager().registerEvents((Listener)new CacheEventHandler(), (Plugin)Dominion.instance);
    }

    public ServerCache getCache() {
        return this.thisServerCache;
    }

    public Map<Integer, ServerCache> getOtherServerCaches() {
        return this.otherServerCaches;
    }

    @Nullable
    public ServerCache getCache(Integer id) {
        if (this.thisServerCache.getServerId().equals(id)) {
            return this.thisServerCache;
        }
        return this.otherServerCaches.get(id);
    }

    public void addServerCache(@NotNull Integer serverId) {
        ServerCache serverCache = new ServerCache(serverId);
        this.otherServerCaches.put(serverId, serverCache);
    }

    public void reloadCache() {
        this.thisServerCache.getDominionCache().load();
        this.thisServerCache.getMemberCache().load();
        this.thisServerCache.getGroupCache().load();
    }

    public void reloadServerCache(@NotNull Integer serverId) {
        CompletableFuture.runAsync(() -> {
            if (!this.otherServerCaches.containsKey(serverId)) {
                XLogger.debug("Server cache not found for serverId: {0}", serverId);
                return;
            }
            this.otherServerCaches.get(serverId).getDominionCache().load();
            this.otherServerCaches.get(serverId).getMemberCache().load();
            this.otherServerCaches.get(serverId).getGroupCache().load();
        });
    }

    public PlayerCache getPlayerCache() {
        return this.playerCache;
    }

    public ResidenceDataCache getResidenceCache() {
        return this.residenceDataCache;
    }

    public void updatePlayerName(@NotNull Player bukkitPlayer) throws Exception {
        PlayerDTO player = this.playerCache.getPlayer(bukkitPlayer.getUniqueId());
        URL skin = null;
        try {
            skin = bukkitPlayer.getPlayerProfile().getTextures().getSkin();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (player != null) {
            player = player.updateLastKnownName(bukkitPlayer.getName(), skin);
        } else {
            PlayerDOO.create(bukkitPlayer);
        }
    }

    @Nullable
    public PlayerDTO getPlayer(String name) {
        return this.playerCache.getPlayer(name);
    }

    @Nullable
    public PlayerDTO getPlayer(@NotNull UUID player) {
        return this.playerCache.getPlayer(player);
    }

    @NotNull
    public String getPlayerName(@NotNull UUID uuid) {
        return this.playerCache.getPlayerName(uuid);
    }

    @NotNull
    public List<String> getPlayerNames() {
        return this.playerCache.getPlayerNames();
    }

    public List<String> getPlayerManageDominionNames(@NotNull UUID player) {
        ArrayList<DominionDTO> dominions = new ArrayList<DominionDTO>(this.thisServerCache.getDominionCache().getPlayerOwnDominionDTOs(player));
        dominions.addAll(this.thisServerCache.getDominionCache().getPlayerAdminDominionDTOs(player));
        if (Configuration.multiServer.enable) {
            for (ServerCache serverCache : this.otherServerCaches.values()) {
                dominions.addAll(serverCache.getDominionCache().getPlayerOwnDominionDTOs(player));
                dominions.addAll(serverCache.getDominionCache().getPlayerAdminDominionDTOs(player));
            }
        }
        ArrayList<String> names = new ArrayList<String>(dominions.size());
        for (DominionDTO dominion : dominions) {
            names.add(dominion.getName());
        }
        return names;
    }

    public List<String> getAllDominionNames() {
        ArrayList<String> names = new ArrayList<String>(this.thisServerCache.getDominionCache().getAllDominionNames());
        if (Configuration.multiServer.enable) {
            for (ServerCache serverCache : this.otherServerCaches.values()) {
                names.addAll(serverCache.getDominionCache().getAllDominionNames());
            }
        }
        return names;
    }

    public List<DominionDTO> getAllDominions() {
        ArrayList<DominionDTO> dominions = new ArrayList<DominionDTO>(this.thisServerCache.getDominionCache().getAllDominions());
        if (Configuration.multiServer.enable) {
            for (ServerCache serverCache : this.otherServerCaches.values()) {
                dominions.addAll(serverCache.getDominionCache().getAllDominions());
            }
        }
        return dominions;
    }

    public List<DominionDTO> getChildrenDominionOf(DominionDTO parent) {
        ArrayList<DominionDTO> dominions = new ArrayList<DominionDTO>(this.thisServerCache.getDominionCache().getChildrenOf(parent.getId()));
        if (Configuration.multiServer.enable) {
            for (ServerCache serverCache : this.otherServerCaches.values()) {
                dominions.addAll(serverCache.getDominionCache().getChildrenOf(parent.getId()));
            }
        }
        return dominions;
    }

    @Nullable
    public DominionDTO getDominion(Integer id) {
        DominionDTO dominion = this.thisServerCache.getDominionCache().getDominion(id);
        if (dominion != null) {
            return dominion;
        }
        if (Configuration.multiServer.enable) {
            for (ServerCache serverCache : this.otherServerCaches.values()) {
                dominion = serverCache.getDominionCache().getDominion(id);
                if (dominion == null) continue;
                return dominion;
            }
        }
        try {
            return DominionDOO.select(id);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    @Nullable
    public DominionDTO getDominion(String name) {
        DominionDTO dominion = this.thisServerCache.getDominionCache().getDominion(name);
        if (dominion != null) {
            return dominion;
        }
        if (Configuration.multiServer.enable) {
            for (ServerCache serverCache : this.otherServerCaches.values()) {
                dominion = serverCache.getDominionCache().getDominion(name);
                if (dominion == null) continue;
                return dominion;
            }
        }
        try {
            return DominionDOO.select(name);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    @Nullable
    public DominionDTO getDominion(Location location) {
        return this.thisServerCache.getDominionCache().getDominion(location);
    }

    public List<DominionDTO> getPlayerOwnDominionDTOs(UUID player) {
        ArrayList<DominionDTO> dominions = new ArrayList<DominionDTO>(this.thisServerCache.getDominionCache().getPlayerOwnDominionDTOs(player));
        if (Configuration.multiServer.enable) {
            for (ServerCache serverCache : this.otherServerCaches.values()) {
                dominions.addAll(serverCache.getDominionCache().getPlayerOwnDominionDTOs(player));
            }
        }
        return dominions;
    }

    public List<DominionDTO> getPlayerAdminDominionDTOs(UUID player) {
        ArrayList<DominionDTO> dominions = new ArrayList<DominionDTO>(this.thisServerCache.getDominionCache().getPlayerAdminDominionDTOs(player));
        if (Configuration.multiServer.enable) {
            for (ServerCache serverCache : this.otherServerCaches.values()) {
                dominions.addAll(serverCache.getDominionCache().getPlayerAdminDominionDTOs(player));
            }
        }
        return dominions;
    }

    @Nullable
    public MemberDTO getMember(@Nullable DominionDTO dominion, @NotNull Player player) {
        return this.getMember(dominion, player.getUniqueId());
    }

    @Nullable
    public MemberDTO getMember(@Nullable DominionDTO dominion, @NotNull UUID player) {
        MemberDTO member = this.thisServerCache.getMemberCache().getMember(dominion, player);
        if (member != null) {
            return member;
        }
        if (Configuration.multiServer.enable) {
            for (ServerCache serverCache : this.otherServerCaches.values()) {
                member = serverCache.getMemberCache().getMember(dominion, player);
                if (member == null) continue;
                return member;
            }
        }
        return null;
    }

    @Nullable
    public GroupDTO getGroup(MemberDTO member) {
        return this.getGroup(member.getGroupId());
    }

    @Nullable
    public GroupDTO getGroup(Integer id) {
        if (id == null) {
            return null;
        }
        if (id == -1) {
            return null;
        }
        GroupDTO group = this.thisServerCache.getGroupCache().getGroup(id);
        if (group != null) {
            return group;
        }
        if (Configuration.multiServer.enable) {
            for (ServerCache serverCache : this.otherServerCaches.values()) {
                group = serverCache.getGroupCache().getGroup(id);
                if (group == null) continue;
                return group;
            }
        }
        return null;
    }

    public boolean needRecheckPlayerStatus() {
        if (this.recheckPlayerStatus) {
            this.recheckPlayerStatus = false;
            return true;
        }
        return false;
    }

    public void recheckPlayerStatus() {
        this.recheckPlayerStatus = true;
    }

    @Nullable
    public DominionDTO getPlayerCurrentDominion(@NotNull Player player) {
        try (AutoTimer ignored = new AutoTimer(Configuration.timer);){
            int current_dom_id;
            Integer last_in_dom_id = this.playerCurrentDominionId.get(player.getUniqueId());
            DominionDTO last_dominion = null;
            DominionCache cache = this.thisServerCache.getDominionCache();
            if (last_in_dom_id != null) {
                last_dominion = cache.getDominion(last_in_dom_id);
            }
            if (Others.isInDominion(last_dominion, player.getLocation()) && cache.getChildrenOf(last_in_dom_id).isEmpty()) {
                this.checkPlayerStates(player, last_dominion);
                DominionDTO dominionDTO = last_dominion;
                return dominionDTO;
            }
            DominionDTO current_dominion = cache.getDominion(player.getLocation());
            int last_dom_id = last_dominion == null ? -1 : last_dominion.getId();
            int n = current_dom_id = current_dominion == null ? -1 : current_dominion.getId();
            if (last_dom_id == current_dom_id) {
                this.checkPlayerStates(player, last_dominion);
                DominionDTO dominionDTO = last_dominion;
                return dominionDTO;
            }
            new PlayerCrossDominionBorderEvent(player, last_dominion, current_dominion).call();
            this.recheckPlayerStatus();
            this.checkPlayerStates(player, current_dominion);
            if (last_dom_id != -1) {
                new PlayerMoveOutDominionEvent(player, last_dominion).call();
            }
            if (current_dom_id != -1) {
                new PlayerMoveInDominionEvent(player, current_dominion).call();
            }
            if (current_dominion == null) {
                this.playerCurrentDominionId.remove(player.getUniqueId());
                DominionDTO dominionDTO = null;
                return dominionDTO;
            }
            this.playerCurrentDominionId.put(player.getUniqueId(), current_dominion.getId());
            DominionDTO dominionDTO = current_dominion;
            return dominionDTO;
        }
    }

    private void checkPlayerStates(@NotNull Player player, @Nullable DominionDTO dominion) {
        if (!this.needRecheckPlayerStatus()) {
            return;
        }
        Others.flyOrNot(player, dominion);
        Others.lightOrNot(player, dominion);
    }

    public void resetPlayerCurrentDominionId(@NotNull Player player) {
        this.playerCurrentDominionId.remove(player.getUniqueId());
    }

    public Integer dominionCount() {
        int count = this.thisServerCache.getDominionCache().count();
        if (Configuration.multiServer.enable) {
            for (ServerCache serverCache : this.otherServerCaches.values()) {
                count += serverCache.getDominionCache().count().intValue();
            }
        }
        return count;
    }

    public Integer groupCount() {
        int count = this.thisServerCache.getGroupCache().count();
        if (Configuration.multiServer.enable) {
            for (ServerCache serverCache : this.otherServerCaches.values()) {
                count += serverCache.getGroupCache().count().intValue();
            }
        }
        return count;
    }

    public Integer memberCount() {
        int count = this.thisServerCache.getMemberCache().count();
        if (Configuration.multiServer.enable) {
            for (ServerCache serverCache : this.otherServerCaches.values()) {
                count += serverCache.getMemberCache().count().intValue();
            }
        }
        return count;
    }

    static {
        UPDATE_INTERVAL = 4000L;
    }
}

