/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.commands;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.CuboidDTO;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.configuration.uis.TextUserInterface;
import cn.lunadeer.dominion.doos.DominionDOO;
import cn.lunadeer.dominion.doos.PlayerDOO;
import cn.lunadeer.dominion.events.dominion.DominionCreateEvent;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.misc.DominionException;
import cn.lunadeer.dominion.uis.MigrateList;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.ResMigration;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.command.Argument;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import java.util.Objects;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MigrationCommand {
    public static SecondaryCommand migrate = new SecondaryCommand("migrate", List.of(new Argument("residence_name", true), new CommandArguments.OptionalPageArgument()), Language.migrationCommandText.migrateDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            MigrationCommand.migrate(sender, this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand migrateAll = new SecondaryCommand("migrate_all", List.of(), Language.migrationCommandText.migrateAllDescription){

        @Override
        public void executeHandler(CommandSender sender) {
            MigrationCommand.migrateAll(sender);
        }
    }.needPermission(Dominion.adminPermission).register();

    public static ListViewButton button(final CommandSender sender, final String residenceName) {
        return (ListViewButton)new ListViewButton(TextUserInterface.migrateListTuiText.button){

            @Override
            public void function(String pageStr) {
                MigrationCommand.migrate(sender, residenceName, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    public static void migrate(CommandSender sender, String resName, String pageStr) {
        try {
            Player player;
            if (!Configuration.residenceMigration) {
                Notification.error(sender, TextUserInterface.migrateListTuiText.notEnabled);
                return;
            }
            List<ResMigration.ResidenceNode> res_data = CacheManager.instance.getResidenceCache().getResidenceData();
            if (res_data == null) {
                throw new DominionException(TextUserInterface.migrateListTuiText.noData, new Object[0]);
            }
            ResMigration.ResidenceNode resNode = res_data.stream().filter(node -> node.name.equals(resName)).findFirst().orElse(null);
            if (resNode == null) {
                throw new DominionException(Language.migrationCommandText.missingResidence, resName);
            }
            if (sender instanceof Player && !(player = (Player)sender).hasPermission(Dominion.adminPermission) && !resNode.owner.equals(player.getUniqueId())) {
                throw new DominionException(Language.migrationCommandText.notYourResidence, resName);
            }
            MigrationCommand.doMigrateCreate(sender, resNode, null);
            MigrateList.show(sender, pageStr);
        }
        catch (Exception e) {
            Notification.error(sender, Language.migrationCommandText.migrateFailed, e.getMessage());
        }
    }

    private static void doMigrateCreate(CommandSender sender, ResMigration.ResidenceNode node, DominionDTO parent) throws Exception {
        PlayerDOO ownerDTO = PlayerDOO.create(node.owner, node.ownerName);
        CuboidDTO cuboidDTO = new CuboidDTO(node.loc1, node.loc2);
        World world = Converts.toWorld(node.world.getUID());
        int renameNumber = 0;
        while (DominionDOO.select((String)(renameNumber == 0 ? node.name : node.name + "_" + renameNumber)) != null) {
            ++renameNumber;
        }
        DominionCreateEvent event = new DominionCreateEvent(sender, (String)(renameNumber == 0 ? node.name : node.name + "_" + renameNumber), ownerDTO.getUuid(), world, cuboidDTO, parent);
        event.setSkipEconomy(true);
        event.callEvent();
        if (!event.isCancelled()) {
            Notification.info(sender, Language.migrationCommandText.migrateSuccess, node.name);
            DominionDTO dominionCreated = event.getDominion();
            Objects.requireNonNull(Objects.requireNonNull(dominionCreated.setTpLocation(node.tpLoc)).setJoinMessage(node.joinMessage)).setLeaveMessage(node.leaveMessage);
            if (node.children != null) {
                for (ResMigration.ResidenceNode child : node.children) {
                    MigrationCommand.doMigrateCreate(sender, child, dominionCreated);
                }
            }
        }
    }

    public static void migrateAll(CommandSender sender) {
        List<ResMigration.ResidenceNode> res_data = CacheManager.instance.getResidenceCache().getResidenceData();
        if (res_data == null || res_data.isEmpty()) {
            Notification.error(sender, TextUserInterface.migrateListTuiText.noData);
            return;
        }
        int successCount = 0;
        for (ResMigration.ResidenceNode resNode : res_data) {
            try {
                MigrationCommand.doMigrateCreate(sender, resNode, null);
                ++successCount;
            }
            catch (Exception e) {
                Notification.error(sender, Language.migrationCommandText.migrateFailed, e.getMessage());
                XLogger.error(e);
            }
        }
        Notification.info(sender, Language.migrationCommandText.migrateSuccess, successCount + "/" + res_data.size());
    }

    public static class MigrationCommandText
    extends ConfigurationPart {
        public String migrateSuccess = "Migrated residence {0} to dominion successfully.";
        public String migrateFailed = "Failed to migrate residence. Reason: {0}";
        public String missingResidence = "Residence {0} not found.";
        public String notYourResidence = "Residence {0} is not yours.";
        public String migrateDescription = "Migrate a specific residence to dominion.";
        public String migrateAllDescription = "Migrate all residences to dominions.";
    }
}

