/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.inputters;

import cn.lunadeer.dominion.commands.DominionOperateCommand;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.events.dominion.modify.DominionReSizeEvent;
import cn.lunadeer.dominion.uis.dominion.manage.SetSize;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.inputter.InputterRunner;
import org.bukkit.command.CommandSender;

public class ResizeDominionInputter {
    public static void createExpandOn(final CommandSender sender, final String dominionName, final DominionReSizeEvent.DIRECTION direction) {
        new InputterRunner(sender, Misc.formatString(Language.resizeDominionInputterText.expandHint, dominionName, direction.name())){

            @Override
            public void run(String input) {
                String numberInput = input.replaceAll("[^\\d.]", "");
                DominionOperateCommand.resize(sender, dominionName, DominionReSizeEvent.TYPE.EXPAND.name(), numberInput, direction.name());
                SetSize.show(sender, dominionName);
            }
        };
    }

    public static void createContractOn(final CommandSender sender, final String dominionName, final DominionReSizeEvent.DIRECTION direction) {
        new InputterRunner(sender, Misc.formatString(Language.resizeDominionInputterText.contractHint, dominionName, direction.name())){

            @Override
            public void run(String input) {
                String numberInput = input.replaceAll("[^\\d.]", "");
                DominionOperateCommand.resize(sender, dominionName, DominionReSizeEvent.TYPE.CONTRACT.name(), numberInput, direction.name());
                SetSize.show(sender, dominionName);
            }
        };
    }

    public static FunctionalButton createExpandTuiButtonOn(final CommandSender sender, final String dominionName, final DominionReSizeEvent.DIRECTION direction) {
        return new FunctionalButton(Language.resizeDominionInputterText.expand){

            @Override
            public void function() {
                ResizeDominionInputter.createExpandOn(sender, dominionName, direction);
            }
        };
    }

    public static FunctionalButton createContractTuiButtonOn(final CommandSender sender, final String dominionName, final DominionReSizeEvent.DIRECTION direction) {
        return new FunctionalButton(Language.resizeDominionInputterText.contract){

            @Override
            public void function() {
                ResizeDominionInputter.createContractOn(sender, dominionName, direction);
            }
        };
    }

    public static class ResizeDominionInputterText
    extends ConfigurationPart {
        public String expand = "EXPAND";
        public String contract = "CONTRACT";
        public String expandHint = "Enter the new size of the {0} expand to {1}.";
        public String contractHint = "Enter the new size of the {0} contract to {1}.";
    }
}

