/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.dominion;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.commands.CopyCommand;
import cn.lunadeer.dominion.commands.DominionOperateCommand;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.configuration.uis.ChestUserInterface;
import cn.lunadeer.dominion.configuration.uis.TextUserInterface;
import cn.lunadeer.dominion.inputters.EditMessageInputter;
import cn.lunadeer.dominion.inputters.RenameDominionInputter;
import cn.lunadeer.dominion.inputters.SetMapColorInputter;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.MainMenu;
import cn.lunadeer.dominion.uis.dominion.DominionList;
import cn.lunadeer.dominion.uis.dominion.copy.CopyMenu;
import cn.lunadeer.dominion.uis.dominion.manage.EnvFlags;
import cn.lunadeer.dominion.uis.dominion.manage.GuestFlags;
import cn.lunadeer.dominion.uis.dominion.manage.Info;
import cn.lunadeer.dominion.uis.dominion.manage.SetSize;
import cn.lunadeer.dominion.uis.dominion.manage.group.GroupList;
import cn.lunadeer.dominion.uis.dominion.manage.member.MemberList;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestListView;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.scui.configuration.ListViewConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class DominionManage
extends AbstractUI {
    public static SecondaryCommand manage = new SecondaryCommand("manage", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.OptionalPageArgument()), Language.uiCommandsDescription.dominionManage){

        @Override
        public void executeHandler(CommandSender sender) {
            DominionManage.show(sender, this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static void show(CommandSender sender, String dominionName, String pageStr) {
        new DominionManage().displayByPreference(sender, dominionName, pageStr);
    }

    public static ListViewButton button(final CommandSender sender, final String dominionName) {
        return (ListViewButton)new ListViewButton(TextUserInterface.dominionManageTuiText.button){

            @Override
            public void function(String pageStr) {
                DominionManage.show(sender, dominionName, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    @Override
    protected void showTUI(final Player player, String ... args) {
        final DominionDTO dominion = Converts.toDominionDTO(args[0]);
        Asserts.assertDominionAdmin(player, dominion);
        int page = Converts.toIntegrity(args[1], 1);
        Line size_info = Line.create().append(Info.button(player, dominion.getName()).build()).append(TextUserInterface.sizeInfoTuiText.description);
        Line env_info = Line.create().append(EnvFlags.button((CommandSender)player, dominion.getName()).build()).append(TextUserInterface.envSettingTuiText.description);
        Line flag_info = Line.create().append(GuestFlags.button((CommandSender)player, dominion.getName()).build()).append(TextUserInterface.guestSettingTuiText.description);
        Line member_list = Line.create().append(MemberList.button((CommandSender)player, dominion.getName()).build()).append(TextUserInterface.memberListTuiText.description);
        Line group_list = Line.create().append(GroupList.button((CommandSender)player, dominion.getName()).build()).append(TextUserInterface.groupListTuiText.description);
        Line set_tp = Line.create().append(new FunctionalButton(TextUserInterface.dominionManageTuiText.setTpButton){

            @Override
            public void function() {
                DominionOperateCommand.setTp((CommandSender)player, dominion.getName());
            }
        }.build()).append(TextUserInterface.dominionManageTuiText.setTpDescription);
        Line rename = Line.create().append(RenameDominionInputter.createTuiButtonOn((CommandSender)player, dominion.getName()).needPermission(Dominion.defaultPermission).build()).append(Language.renameDominionInputterText.description);
        Line enter_msg = Line.create().append(EditMessageInputter.createEnterTuiButtonOn((CommandSender)player, dominion.getName()).needPermission(Dominion.defaultPermission).build()).append(Language.editMessageInputterText.enterDescription);
        Line leave_msg = Line.create().append(EditMessageInputter.createLeaveTuiButtonOn((CommandSender)player, dominion.getName()).needPermission(Dominion.defaultPermission).build()).append(Language.editMessageInputterText.leaveDescription);
        Line map_color = Line.create().append(SetMapColorInputter.createTuiButtonOn((CommandSender)player, dominion.getName()).build()).append((TextComponent)Component.text((String)Language.setMapColorInputterText.description).append((Component)Component.text((String)dominion.getColor(), (TextColor)TextColor.color((int)dominion.getColorR(), (int)dominion.getColorG(), (int)dominion.getColorB()))));
        Line copy_menu = Line.create().append(CopyMenu.button((CommandSender)player, dominion.getName()).build()).append(TextUserInterface.copyMenuTuiText.description);
        ListView view = ListView.create(10, DominionManage.button((CommandSender)player, dominion.getName()));
        view.title(Misc.formatString(TextUserInterface.dominionManageTuiText.title, dominion.getName())).navigator(Line.create().append(MainMenu.button((CommandSender)player).build()).append(DominionList.button((CommandSender)player).build()).append(dominion.getName())).add(size_info).add(env_info).add(flag_info).add(member_list).add(group_list).add(set_tp).add(rename).add(enter_msg).add(leave_msg);
        if (Configuration.webMapRenderer.blueMap || Configuration.webMapRenderer.dynmap) {
            view.add(map_color);
        }
        view.add(copy_menu);
        view.showOn(player, page);
    }

    @Override
    protected void showCUI(final Player player, String ... args) {
        final DominionDTO dominion = Converts.toDominionDTO(args[0]);
        Asserts.assertDominionAdmin(player, dominion);
        final ChestListView view = ChestUserInterfaceManager.getInstance().getListViewOf(player);
        view.setTitle(Misc.formatString(ChestUserInterface.dominionManageCui.title, dominion.getName()));
        view.applyListConfiguration(ChestUserInterface.dominionManageCui.listConfiguration, Converts.toIntegrity(args[1]));
        view.setButton(ChestUserInterface.dominionManageCui.backButton.getSymbol(), new ChestButton(ChestUserInterface.dominionManageCui.backButton){

            @Override
            public void onClick(ClickType type) {
                DominionList.show((CommandSender)player, "1");
            }
        });
        view.setButton(ChestUserInterface.dominionManageCui.dominionInfoButton.getSymbol(), new ChestButton(ChestUserInterface.dominionManageCui.dominionInfoButton){

            @Override
            public void onClick(ClickType type) {
                SetSize.show((CommandSender)player, dominion.getName());
            }
        }.setLoreArgs(dominion.getCuboid().xLength() + " x " + dominion.getCuboid().yLength() + " x " + dominion.getCuboid().zLength(), dominion.getCuboid().y1() + " ~ " + dominion.getCuboid().y2(), dominion.getCuboid().getSquare(), dominion.getCuboid().getVolume(), String.valueOf(dominion.getTpLocation().getWorld()) + ":" + dominion.getTpLocation().getBlockX() + "," + dominion.getTpLocation().getBlockY() + "," + dominion.getTpLocation().getBlockZ()));
        view.addItem(new ChestButton(ChestUserInterface.dominionManageCui.envSettingButton){

            @Override
            public void onClick(ClickType type) {
                EnvFlags.show((CommandSender)player, dominion.getName(), "1");
            }
        });
        view.addItem(new ChestButton(ChestUserInterface.dominionManageCui.guestSettingButton){

            @Override
            public void onClick(ClickType type) {
                GuestFlags.show((CommandSender)player, dominion.getName(), "1");
            }
        });
        view.addItem(new ChestButton(ChestUserInterface.dominionManageCui.memberListButton){

            @Override
            public void onClick(ClickType type) {
                MemberList.show((CommandSender)player, dominion.getName(), "1");
            }
        });
        view.addItem(new ChestButton(ChestUserInterface.dominionManageCui.groupListButton){

            @Override
            public void onClick(ClickType type) {
                GroupList.show((CommandSender)player, dominion.getName(), "1");
            }
        });
        view.addItem(new ChestButton(ChestUserInterface.dominionManageCui.setTpButton){

            @Override
            public void onClick(ClickType type) {
                DominionOperateCommand.setTp((CommandSender)player, dominion.getName());
            }
        });
        view.addItem(new ChestButton(ChestUserInterface.dominionManageCui.renameButton){

            @Override
            public void onClick(ClickType type) {
                RenameDominionInputter.createOn((CommandSender)player, dominion.getName());
                view.close();
            }
        });
        view.addItem(new ChestButton(ChestUserInterface.dominionManageCui.enterMessageButton){

            @Override
            public void onClick(ClickType type) {
                EditMessageInputter.createEnterOn((CommandSender)player, dominion.getName());
                view.close();
            }
        });
        view.addItem(new ChestButton(ChestUserInterface.dominionManageCui.leaveMessageButton){

            @Override
            public void onClick(ClickType type) {
                EditMessageInputter.createLeaveOn((CommandSender)player, dominion.getName());
                view.close();
            }
        });
        view.addItem(new ChestButton(ChestUserInterface.dominionManageCui.setMapColorButton){

            @Override
            public void onClick(ClickType type) {
                SetMapColorInputter.createOn((CommandSender)player, dominion.getName());
                view.close();
            }
        });
        view.addItem(new ChestButton(ChestUserInterface.dominionManageCui.copyMenuButton){

            @Override
            public void onClick(ClickType type) {
                CopyMenu.show((CommandSender)player, dominion.getName(), "1");
            }
        });
        view.addItem(new ChestButton(ChestUserInterface.dominionManageCui.deleteButton){

            @Override
            public void onClick(ClickType type) {
                DominionOperateCommand.delete((CommandSender)player, dominion.getName(), "");
                view.close();
            }
        });
        view.open();
    }

    @Override
    protected void showConsole(CommandSender sender, String ... args) throws Exception {
        DominionDTO dominion = Converts.toDominionDTO(args[0]);
        Notification.info(sender, ChestUserInterface.dominionManageCui.title, dominion.getName());
        Notification.info(sender, EnvFlags.flags.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, EnvFlags.flags.getDescription());
        Notification.info(sender, GuestFlags.flags.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, GuestFlags.flags.getDescription());
        Notification.info(sender, MemberList.list.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, MemberList.list.getDescription());
        Notification.info(sender, GroupList.list.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, GroupList.list.getDescription());
        Notification.info(sender, DominionOperateCommand.rename.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, DominionOperateCommand.rename.getDescription());
        Notification.info(sender, DominionOperateCommand.resize.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, DominionOperateCommand.resize.getDescription());
        Notification.info(sender, DominionOperateCommand.setMessage.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, DominionOperateCommand.setMessage.getDescription());
        Notification.info(sender, CopyCommand.copyEnvironmentCommand.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, CopyCommand.copyEnvironmentCommand.getDescription());
        Notification.info(sender, CopyCommand.copyGuestCommand.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, CopyCommand.copyGuestCommand.getDescription());
        Notification.info(sender, CopyCommand.copyMemberCommand.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, CopyCommand.copyMemberCommand.getDescription());
        Notification.info(sender, CopyCommand.copyGroupCommand.getUsage());
        Notification.info(sender, Language.consoleText.descPrefix, CopyCommand.copyGroupCommand.getDescription());
    }

    public static class DominionManageTuiText
    extends ConfigurationPart {
        public String title = "Manage {0}";
        public String button = "MANAGE";
        public String setTpButton = "SET TP";
        public String setTpDescription = "Set your current location as tp location.";
    }

    public static class DominionManageCui
    extends ConfigurationPart {
        public String title = "\u00a76\u2726 \u00a7a\u00a7lManage {0} \u00a76\u2726";
        public ListViewConfiguration listConfiguration = new ListViewConfiguration('i', List.of("<###I####", "#i#i#i#i#", "#i#i#i#i#", "p#######n"));
        public ButtonConfiguration backButton = ButtonConfiguration.createMaterial('<', Material.RED_STAINED_GLASS_PANE, "\u00a7c\u00ab Back to Dominion List", List.of("\u00a77Return to your dominion list", "\u00a78to manage other dominions.", "", "\u00a7e\u25b6 Click to go back"));
        public ButtonConfiguration dominionInfoButton = ButtonConfiguration.createMaterial('I', Material.GRASS_BLOCK, "\u00a76\ud83d\udcca \u00a7e\u00a7lDominion Overview", List.of("", "\u00a7f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "\u00a7b\u25aa \u00a77Size:     \u00a7f{0}", "\u00a7b\u25aa \u00a77Height:   \u00a7f{1}", "\u00a7b\u25aa \u00a77Square:   \u00a7f{2} \u00a77blocks\u00b2", "\u00a7b\u25aa \u00a77Volume:   \u00a7f{3} \u00a77blocks\u00b3", "\u00a7b\u25aa \u00a77Location: \u00a7f{4}", "\u00a7f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "", "\u00a7a\u25b6 \u00a72Click \u00a77- Resize dominion", "", "\u00a78\ud83d\udca1 Manage your dominion's size."));
        public ButtonConfiguration envSettingButton = ButtonConfiguration.createMaterial('i', Material.COMPASS, "\u00a72\ud83c\udf0d \u00a7aEnvironment Settings", List.of("\u00a77Configure environment rules", "\u00a77for this dominion.", "", "\u00a7a\u25b6 Click to configure", "", "\u00a78Weather, time, mob spawning..."));
        public ButtonConfiguration guestSettingButton = ButtonConfiguration.createMaterial('i', Material.OAK_DOOR, "\u00a7e\ud83d\udeaa \u00a76Guest Permissions", List.of("\u00a77Set permissions for visitors", "\u00a77who aren't members.", "", "\u00a76\u25b6 Click to configure", "", "\u00a78Build, interact, use items..."));
        public ButtonConfiguration memberListButton = ButtonConfiguration.createMaterial('i', Material.PLAYER_HEAD, "\u00a7b\ud83d\udc65 \u00a73Member Management", List.of("\u00a77View and manage dominion", "\u00a77members and their roles.", "", "\u00a73\u25b6 Click to manage members", "", "\u00a78Add, remove, set permissions..."));
        public ButtonConfiguration groupListButton = ButtonConfiguration.createMaterial('i', Material.CHEST, "\u00a7d\ud83d\udce6 \u00a75Group Management", List.of("\u00a77Create and manage member", "\u00a77groups with custom permissions.", "", "\u00a75\u25b6 Click to manage groups", "", "\u00a78Create ranks, set titles..."));
        public ButtonConfiguration setTpButton = ButtonConfiguration.createMaterial('i', Material.ENDER_PEARL, "\u00a79\ud83c\udfaf \u00a7bSet Teleport Point", List.of("\u00a77Set your current location", "\u00a77as the dominion's TP point.", "", "\u00a7b\u25b6 Click to set location", "", "\u00a78Members can teleport here!"));
        public ButtonConfiguration renameButton = ButtonConfiguration.createMaterial('i', Material.NAME_TAG, "\u00a7e\u270f\ufe0f \u00a76Rename Dominion", List.of("\u00a77Change the name of", "\u00a77this dominion.", "", "\u00a76\u25b6 Click to rename", "", "\u00a78Choose a memorable name!"));
        public ButtonConfiguration enterMessageButton = ButtonConfiguration.createMaterial('i', Material.WRITABLE_BOOK, "\u00a7a\ud83d\udcdd \u00a72Enter Message", List.of("\u00a77Edit the welcome message", "\u00a77shown when players enter.", "", "\u00a72\u25b6 Click to edit message", "", "\u00a78Greet your visitors!"));
        public ButtonConfiguration leaveMessageButton = ButtonConfiguration.createMaterial('i', Material.BOOK, "\u00a7c\ud83d\udcc4 \u00a74Leave Message", List.of("\u00a77Edit the farewell message", "\u00a77shown when players leave.", "", "\u00a74\u25b6 Click to edit message", "", "\u00a78Say goodbye in style!"));
        public ButtonConfiguration setMapColorButton = ButtonConfiguration.createMaterial('i', Material.PAINTING, "\u00a76\ud83c\udfa8 \u00a7eMap Color", List.of("\u00a77Set the display color for", "\u00a77this dominion on the map.", "", "\u00a7e\u25b6 Click to choose color", "", "\u00a78Make it stand out!"));
        public ButtonConfiguration copyMenuButton = ButtonConfiguration.createMaterial('i', Material.GLASS, "\u00a7b\ud83d\udccb \u00a73Copy Settings", List.of("\u00a77Copy permissions and settings", "\u00a77to other dominions.", "", "\u00a73\u25b6 Click to access copy menu", "", "\u00a78Save time with templates!"));
        public ButtonConfiguration deleteButton = ButtonConfiguration.createMaterial('i', Material.RED_DYE, "\u00a7c\ud83d\udc80 \u00a74Delete Dominion", List.of("\u00a7c\u00a7lDANGER ZONE", "\u00a77Permanently delete this", "\u00a77dominion and all its data.", "", "\u00a74\u25b6 Click to delete", "", "\u00a7c\u26a0 This cannot be undone!"));
    }
}

