/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.scui;

import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.utils.ColorParser;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.scheduler.Scheduler;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public abstract class ChestButton {
    private final ItemStack item;
    private String displayName;
    private List<String> lore;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ChestButton(ButtonConfiguration config) {
        if (config.material.contains(";")) {
            String[] parts = config.material.split(";");
            if (parts.length != 3 || !parts[0].equalsIgnoreCase("PLAYER_HEAD")) throw new IllegalArgumentException("Invalid material type: " + config.material);
            this.item = new ItemStack(Material.PLAYER_HEAD);
            Scheduler.runTaskAsync(() -> {
                PlayerTextures textures;
                PlayerProfile profile;
                SkullMeta meta;
                block7: {
                    meta = (SkullMeta)this.item.getItemMeta();
                    profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID(), null);
                    textures = profile.getTextures();
                    try {
                        if (parts[1].equalsIgnoreCase("B64")) {
                            String textureDecoded = new String(Base64.getDecoder().decode(parts[2]));
                            JSONObject json = (JSONObject)new JSONParser().parse(textureDecoded);
                            String skinUrlString = (String)((JSONObject)((JSONObject)json.get((Object)"textures")).get((Object)"SKIN")).get((Object)"url");
                            textures.setSkin(new URL(skinUrlString));
                            break block7;
                        }
                        if (parts[1].equalsIgnoreCase("URL")) {
                            String skinUrlString = parts[2];
                            textures.setSkin(new URL(skinUrlString));
                            break block7;
                        }
                        if (parts[1].equalsIgnoreCase("NAME")) {
                            PlayerDTO cachedPlayer = CacheManager.instance.getPlayer(parts[2]);
                            if (cachedPlayer == null) {
                                URL url = new URL("http://textures.minecraft.net/texture/613ba1403f98221fab6f4ae0f9e5298068262258966e8f9e53cdedd97aa45ef1");
                                textures.setSkin(url);
                            } else {
                                textures.setSkin(cachedPlayer.getSkinUrl());
                            }
                            break block7;
                        }
                        throw new IllegalArgumentException("Invalid PLAYER_HEAD texture type: " + parts[1] + ". Expected 'B64' or 'URL' or 'NAME'.");
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Failed to parse texture data: " + parts[2], e);
                    }
                }
                profile.setTextures(textures);
                meta.setOwnerProfile(profile);
                this.item.setItemMeta((ItemMeta)meta);
            });
        } else {
            this.item = new ItemStack(Material.valueOf((String)config.material));
        }
        this.displayName = config.name;
        this.lore = new ArrayList<String>(config.lore);
    }

    public ChestButton setDisplayNameArgs(Object ... args) {
        this.displayName = Misc.formatString(this.displayName, args);
        return this;
    }

    public ChestButton setLoreArgs(Object ... args) {
        this.lore = Misc.formatStringList(this.lore, args);
        return this;
    }

    public abstract void onClick(ClickType var1);

    public ItemStack build(Player viewOwner) {
        ItemMeta meta = this.item.getItemMeta();
        if (this.displayName != null) {
            this.displayName = Misc.setPlaceholder(viewOwner, this.displayName);
            this.displayName = ColorParser.getBukkitType(this.displayName);
            meta.setDisplayName(this.displayName);
        }
        if (this.lore != null) {
            for (int i = 0; i < this.lore.size(); ++i) {
                this.lore.set(i, Misc.setPlaceholder(viewOwner, this.lore.get(i)));
                this.lore.set(i, ColorParser.getBukkitType(this.lore.get(i)));
            }
            meta.setLore(this.lore);
        }
        this.item.setItemMeta(meta);
        return this.item;
    }
}

