/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.stui.components.buttons;

import cn.lunadeer.dominion.utils.stui.ViewStyles;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public class Button {
    private String prefix = "[";
    private String suffix = "]";
    protected String text = "";
    protected ClickEvent.Action action = null;
    private String hoverText = "";
    protected String clickExecute = "";
    TextColor color = ViewStyles.ACTION;
    TextColor disabledColor = TextColor.color((int)0x666666);
    private String disabledText = null;

    public TextComponent build() {
        TextComponent.Builder builder = Component.text();
        builder.append((Component)Component.text((String)this.prefix, (TextColor)this.color));
        builder.append((Component)Component.text((String)this.text, (TextColor)this.color));
        builder.append((Component)Component.text((String)this.suffix, (TextColor)this.color));
        if (this.action != null && !this.clickExecute.isEmpty() && this.disabledText == null) {
            builder.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)this.action, (String)this.clickExecute));
        }
        if (this.disabledText != null) {
            ((TextComponent.Builder)builder.hoverEvent((HoverEventSource)Component.text((String)this.disabledText))).style(Style.style((TextDecoration)TextDecoration.STRIKETHROUGH));
        } else if (!this.hoverText.isEmpty()) {
            builder.hoverEvent((HoverEventSource)Component.text((String)this.hoverText));
        }
        return (TextComponent)builder.build();
    }

    public Button(String text) {
        this.text = text;
    }

    public Button setText(String text) {
        this.text = text;
        return this;
    }

    public Button setPreSufIx(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
        return this;
    }

    public Button setHoverText(String hoverText) {
        this.hoverText = hoverText;
        return this;
    }

    public Button setColor(TextColor color) {
        this.color = color;
        return this;
    }

    public Button setDisabled(String hint) {
        this.disabledText = hint;
        this.color = this.disabledColor;
        return this;
    }

    public Button red() {
        this.color = ViewStyles.SEVERE;
        return this;
    }

    public Button green() {
        this.color = ViewStyles.NORMAL;
        return this;
    }
}

