/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.commands;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import cn.lunadeer.dominion.events.member.MemberAddedEvent;
import cn.lunadeer.dominion.events.member.MemberRemovedEvent;
import cn.lunadeer.dominion.events.member.MemberSetFlagEvent;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.tuis.dominion.manage.member.MemberList;
import cn.lunadeer.dominion.uis.tuis.dominion.manage.member.MemberSetting;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.Argument;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import java.util.List;
import org.bukkit.command.CommandSender;

public class MemberCommand {
    public static SecondaryCommand addMember = new SecondaryCommand("member_add", (List)List.of(new CommandArguments.RequiredDominionArgument(), new Argument("player_name", true))){

        @Override
        public void executeHandler(CommandSender sender) {
            MemberCommand.addMember(sender, this.getArgumentValue(0), this.getArgumentValue(1));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand setMemberPrivilege = new SecondaryCommand("member_set_pri", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.RequiredMemberArgument(0), new CommandArguments.PriFlagArgument(), new CommandArguments.BollenOption(), new CommandArguments.OptionalPageArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            MemberCommand.setMemberPrivilege(sender, this.getArgumentValue(0), this.getArgumentValue(1), this.getArgumentValue(2), this.getArgumentValue(3), this.getArgumentValue(4));
        }
    }.needPermission(Dominion.defaultPermission).register();
    public static SecondaryCommand removeMember = new SecondaryCommand("member_remove", List.of(new CommandArguments.RequiredDominionArgument(), new CommandArguments.RequiredMemberArgument(0), new CommandArguments.OptionalPageArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            MemberCommand.removeMember(sender, this.getArgumentValue(0), this.getArgumentValue(1), this.getArgumentValue(2));
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static void addMember(CommandSender sender, String dominionName, String playerName) {
        try {
            PlayerDTO player = Converts.toPlayerDTO(playerName);
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            new MemberAddedEvent(sender, dominion, player).call();
            MemberList.show(sender, dominionName, "1");
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static void setMemberPrivilege(CommandSender sender, String dominionName, String playerName, String flagName, String valueStr, String pageStr) {
        try {
            PriFlag flag = Converts.toPriFlag(flagName);
            boolean value = Converts.toBoolean(valueStr);
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            MemberDTO member = Converts.toMemberDTO(dominion, playerName);
            new MemberSetFlagEvent(sender, dominion, member, flag, value).call();
            MemberSetting.show(sender, dominionName, playerName, pageStr);
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }

    public static void removeMember(CommandSender sender, String dominionName, String playerName, String pageStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            MemberDTO member = Converts.toMemberDTO(dominion, playerName);
            new MemberRemovedEvent(sender, dominion, member).call();
            MemberList.show(sender, dominionName, pageStr);
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }
}

