/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.configuration;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.flag.Flag;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.configuration.Limitation;
import cn.lunadeer.dominion.managers.DatabaseTables;
import cn.lunadeer.dominion.utils.MessageDisplay;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.configuration.Comments;
import cn.lunadeer.dominion.utils.configuration.ConfigurationFile;
import cn.lunadeer.dominion.utils.configuration.ConfigurationManager;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.configuration.HandleManually;
import cn.lunadeer.dominion.utils.configuration.PostProcess;
import cn.lunadeer.dominion.utils.databse.DatabaseManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Configuration
extends ConfigurationFile {
    @Comments(value={"Do not modify this value."})
    public static int version = 2;
    @Comments(value={"The settings of the database."})
    public static Database database = new Database();
    @Comments(value={"The settings of the multi server.", "If you have multiple servers proxied by BungeeCord, you can configure and enable this.", "Player can manage/teleport across multi-servers.", "Database with type sqlite is not supported in multi-server mode.", "For migration of existing data, please refer to the documentation.", "https://dominion.lunadeer.cn/notes/doc/owner/other/multi-server/"})
    public static MultiServer multiServer = new MultiServer();
    @Comments(value={"Language of the plugin, see others in the plugins/Dominion/languages folder."})
    public static String language = "en_us";
    @Comments(value={"Radius of the auto create dominion. -1 to disable."})
    public static int autoCreateRadius = 10;
    @Comments(value={"If player don't login for this days, his dominion will be auto cleaned.", "Set to -1 to disable."})
    public static int autoCleanAfterDays = 180;
    @Comments(value={"Prevent player from creating dominion around the spawn point."})
    public static int serverSpawnProtectionRadius = 10;
    @Comments(value={"Tool used to select position for creating dominion."})
    public static String selectTool = "ARROW";
    @Comments(value={"Tool used to show information of clicked dominion."})
    public static String infoTool = "STRING";
    @Comments(value={"The settings of the plugin message."})
    public static PluginMessage pluginMessage = new PluginMessage();
    @Comments(value={"Render dominion on web map."})
    public static WebMapRenderer webMapRenderer = new WebMapRenderer();
    @Comments(value={"Weather the player can migrate residence data to dominion."})
    public static boolean residenceMigration = false;
    @Comments(value={"Weather the player have dominion.admin permission can bypass the dominion limitation."})
    public static boolean adminBypass = true;
    @Comments(value={"The settings of the group title.", "Player can use there group name as title in tab list."})
    public static GroupTitle groupTitle = new GroupTitle();
    @Comments(value={"The settings of the external link."})
    public static ExternalLinks externalLinks = new ExternalLinks();
    @Comments(value={"Player with these permission nodes won't be affected by dominion's fly limitation."})
    public static List<String> flyPermissionNodes = List.of("essentials.fly", "cmi.command.fly");
    @Comments(value={"Check for updates by internet."})
    public static boolean checkUpdate = true;
    @Comments(value={"Debug mode, if report bugs turn this on."})
    public static boolean debug = false;
    @Comments(value={"Performance recorder, don't open this unless you are debugging."})
    public static boolean timer = false;
    @HandleManually
    public static Map<String, Limitation> limitations = new HashMap<String, Limitation>();

    @HandleManually
    public static void loadFlagConfiguration() throws IOException {
        XLogger.info(Language.configurationText.loadingFlag);
        File yamlFile = new File(Dominion.instance.getDataFolder(), "flags.yml");
        if (!yamlFile.exists()) {
            boolean bl = yamlFile.createNewFile();
        }
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)yamlFile);
        for (Flag flag : Flags.getAllFlags()) {
            if (yaml.contains(flag.getConfigurationDefaultKey())) {
                flag.setDefaultValue(yaml.getBoolean(flag.getConfigurationDefaultKey()));
            } else {
                yaml.set(flag.getConfigurationDefaultKey(), (Object)flag.getDefaultValue());
            }
            if (yaml.contains(flag.getConfigurationEnableKey())) {
                flag.setEnable(yaml.getBoolean(flag.getConfigurationEnableKey()));
            } else {
                yaml.set(flag.getConfigurationEnableKey(), (Object)flag.getEnable());
            }
            yaml.setInlineComments(flag.getConfigurationNameKey(), Collections.singletonList(flag.getDisplayName() + "-" + flag.getDescription()));
        }
        yaml.save(yamlFile);
        XLogger.info(Language.configurationText.loadFlagSuccess);
    }

    @PostProcess
    public static void checkConfigurationParams() {
        if (Configuration.database.type.equalsIgnoreCase("sqlite") && Configuration.multiServer.enable) {
            XLogger.error(Language.configurationText.multiServerSqlite);
            Configuration.multiServer.enable = false;
        }
        if (Configuration.multiServer.serverId <= 0) {
            XLogger.error(Language.configurationText.serverIdInvalid);
            Configuration.multiServer.enable = false;
        }
        if (autoCreateRadius < 0 && autoCreateRadius != -1) {
            autoCreateRadius = -1;
        }
        if (autoCleanAfterDays < 0 && autoCleanAfterDays != -1) {
            autoCleanAfterDays = -1;
        }
        if (Material.matchMaterial((String)selectTool) == null) {
            XLogger.warn("Invalid select tool: {0}", selectTool);
            selectTool = "ARROW";
        }
        if (Material.matchMaterial((String)infoTool) == null) {
            XLogger.warn("Invalid info tool: {0}", infoTool);
            infoTool = "STRING";
        }
        try {
            MessageDisplay.Place.valueOf(Configuration.pluginMessage.noPermissionDisplayPlace.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            XLogger.warn("Invalid no permission display place: {0}", Configuration.pluginMessage.noPermissionDisplayPlace);
            Configuration.pluginMessage.noPermissionDisplayPlace = "ACTION_BAR";
        }
        try {
            MessageDisplay.Place.valueOf(Configuration.pluginMessage.enterLeaveDisplayPlace);
        }
        catch (IllegalArgumentException e) {
            XLogger.warn("Invalid enter leave display place: {0}", Configuration.pluginMessage.enterLeaveDisplayPlace);
            Configuration.pluginMessage.enterLeaveDisplayPlace = "ACTION_BAR";
        }
    }

    @PostProcess
    public static void loadLimitations() {
        File[] files;
        XLogger.info(Language.configurationText.loadingLimitations);
        File folder = new File(Dominion.instance.getDataFolder(), "limitations");
        if (!folder.exists()) {
            boolean bl = folder.mkdirs();
        }
        if ((files = folder.listFiles()) == null) {
            return;
        }
        if (files.length == 0) {
            try {
                XLogger.info(Language.configurationText.savingDefaultLimitation);
                ConfigurationManager.saveDefault(Limitation.class, new File(folder, "default.yml"));
                limitations.put("default", new Limitation());
            }
            catch (Exception e) {
                XLogger.warn(Language.configurationText.saveLimitationFail, e.getMessage());
            }
            return;
        }
        for (File file : files) {
            try {
                XLogger.info(Language.configurationText.loadingLimitation, file.getName());
                ConfigurationFile limitationFile = ConfigurationManager.load(Limitation.class, file, "version");
                Limitation limitation = (Limitation)limitationFile;
                limitations.put(file.getName().replace(".yml", ""), limitation);
            }
            catch (Exception e) {
                XLogger.warn(Language.configurationText.loadLimitationFail, file.getName(), e.getMessage());
            }
        }
        if (!limitations.containsKey("default")) {
            try {
                ConfigurationManager.saveDefault(Limitation.class, new File(folder, "default.yml"));
                limitations.put("default", new Limitation());
            }
            catch (Exception e) {
                XLogger.warn(Language.configurationText.saveLimitationFail, e.getMessage());
            }
        }
        XLogger.info(Language.configurationText.loadLimitations, limitations.size(), String.join((CharSequence)", ", limitations.keySet()));
    }

    @PostProcess
    public void setDebug() {
        XLogger.setDebug(debug);
        if (debug) {
            XLogger.warn(Language.configurationText.debugEnabled);
        }
    }

    @NotNull
    public static Limitation getPlayerLimitation(@Nullable Player player) {
        if (player == null) {
            return limitations.get("default");
        }
        ArrayList<Limitation> playerLimitations = new ArrayList<Limitation>();
        for (String group : limitations.keySet()) {
            if (group.equals("default") || !player.hasPermission("group." + group)) continue;
            playerLimitations.add(limitations.get(group));
        }
        if (playerLimitations.isEmpty()) {
            return limitations.get("default");
        }
        playerLimitations.sort(Comparator.comparingInt(o -> o.priority));
        return (Limitation)playerLimitations.get(playerLimitations.size() - 1);
    }

    private static void handleLegacyConfiguration() {
        File dataFolder = Dominion.instance.getDataFolder();
        File legacyGroupsFolder = new File(dataFolder, "groups");
        if (!legacyGroupsFolder.exists()) {
            return;
        }
        File legacyFolder = new File(dataFolder, "legacy");
        if (!legacyFolder.exists()) {
            legacyFolder.mkdirs();
        }
        Configuration.moveFilesToFolder(legacyGroupsFolder, new File(legacyFolder, "groups"));
        new File(dataFolder, "config.yml").renameTo(new File(legacyFolder, "config.yml"));
        Configuration.moveFilesToFolder(new File(dataFolder, "languages"), new File(legacyFolder, "languages"));
    }

    private static void moveFilesToFolder(File sourceFolder, File targetFolder) {
        if (!targetFolder.exists()) {
            targetFolder.mkdirs();
        }
        for (File file : Objects.requireNonNull(sourceFolder.listFiles())) {
            file.renameTo(new File(targetFolder, file.getName()));
        }
        sourceFolder.delete();
    }

    public static void loadConfigurationAndDatabase(CommandSender sender) throws Exception {
        Configuration.handleLegacyConfiguration();
        ConfigurationManager.load(Configuration.class, new File(Dominion.instance.getDataFolder(), "config.yml"), "version");
        Notification.info((CommandSender)(sender != null ? sender : Dominion.instance.getServer().getConsoleSender()), Language.configurationText.loadConfiguration);
        try {
            File languagesFolder = new File(Dominion.instance.getDataFolder(), "languages");
            if (!languagesFolder.exists()) {
                languagesFolder.mkdir();
            }
            for (Language.LanguageCode code : Language.LanguageCode.values()) {
                if (new File(languagesFolder, code.name() + ".yml").exists()) continue;
                Dominion.instance.saveResource("languages/" + code.name() + ".yml", false);
            }
            Notification.info((CommandSender)(sender != null ? sender : Dominion.instance.getServer().getConsoleSender()), Language.configurationText.loadingLanguage, language);
            ConfigurationManager.load(Language.class, new File(Dominion.instance.getDataFolder(), "languages/" + language + ".yml"));
            Notification.info((CommandSender)(sender != null ? sender : Dominion.instance.getServer().getConsoleSender()), Language.configurationText.loadLanguageSuccess, language);
        }
        catch (Exception e) {
            Notification.error((CommandSender)(sender != null ? sender : Dominion.instance.getServer().getConsoleSender()), Language.configurationText.loadLanguageFail, language, e.getMessage());
        }
        Configuration.loadFlagConfiguration();
        Notification.info((CommandSender)(sender != null ? sender : Dominion.instance.getServer().getConsoleSender()), Language.configurationText.prepareDatabase);
        if (DatabaseManager.instance == null) {
            new DatabaseManager(Dominion.instance, Configuration.database.type, Configuration.database.host, Configuration.database.port, Configuration.database.database, Configuration.database.username, Configuration.database.password);
        } else {
            DatabaseManager.instance.set(Configuration.database.type, Configuration.database.host, Configuration.database.port, Configuration.database.database, Configuration.database.username, Configuration.database.password);
        }
        DatabaseManager.instance.reconnect();
        Notification.info((CommandSender)(sender != null ? sender : Dominion.instance.getServer().getConsoleSender()), Language.configurationText.databaseConnected);
        DatabaseTables.migrate();
    }

    public static class ConfigurationText
    extends ConfigurationPart {
        public String loadingLanguage = "Loading language {0}...";
        public String loadLanguageFail = "Failed to load language {0} reason: {1}, using default en_us.";
        public String loadLanguageSuccess = "Successfully loaded language {0}.";
        public String loadingFlag = "Loading flag configuration...";
        public String loadFlagSuccess = "Successfully loaded flag configuration.";
        public String loadingLimitations = "Loading limitation configuration...";
        public String savingDefaultLimitation = "Because no limitation file found, saving default limitation file.";
        public String saveLimitationFail = "Failed to save limitation file: {0}";
        public String loadingLimitation = "Loading limitation file: {0}...";
        public String loadLimitationFail = "Failed to load limitation file: {0} reason: {1}";
        public String loadLimitations = "Successfully loaded {0} limitations: {1}.";
        public String loadConfiguration = "Successfully loaded configuration.";
        public String debugEnabled = "Debug mode enabled.";
        public String prepareDatabase = "Preparing database...";
        public String databaseConnected = "Database connected successfully.";
        public String multiServerSqlite = "Database with type sqlite is not supported in multi-server mode, disabled multi-server mode.";
        public String serverIdInvalid = "Server id must be positive integer (> 0), disabled multi-server mode.";
    }

    public static class Database
    extends ConfigurationPart {
        @Comments(value={"Supported types: sqlite, mysql, pgsql"})
        public String type = "sqlite";
        @Comments(value={"The host of the database."})
        public String host = "localhost";
        @Comments(value={"The port of the database."})
        public String port = "3306";
        @Comments(value={"The database name."})
        public String database = "dominion";
        @Comments(value={"The username of the database."})
        public String username = "dominion";
        @Comments(value={"The password of the database."})
        public String password = "dominion";
    }

    public static class MultiServer
    extends ConfigurationPart {
        @Comments(value={"Enable multi server mode."})
        public boolean enable = false;
        @Comments(value={"The name of this server.", "This should be the same as configured in BC (Velocity)."})
        public String serverName = "server";
        @Comments(value={"The id of this server, must be unique among all servers.", "Must be positive integer. > 0", "DO NOT CHANGE THIS AFTER THERE ARE DATA IN THE DATABASE."})
        public int serverId = 1;
    }

    public static class PluginMessage
    extends ConfigurationPart {
        @Comments(value={"The default message when player enter/leave dominion.", "Variables: {OWNER} - owner of the dominion, {DOM} - name of the dominion."})
        public String defaultEnterMessage = "&3{OWNER}: Welcome to {DOM}!";
        public String defaultLeaveMessage = "&3{OWNER}: Leaving {DOM}...";
        @Comments(value={"Where to show the message.", "Supported types: BOSS_BAR, ACTION_BAR, TITLE, SUBTITLE, CHAT"})
        public String noPermissionDisplayPlace = "ACTION_BAR";
        public String enterLeaveDisplayPlace = "ACTION_BAR";
    }

    public static class WebMapRenderer
    extends ConfigurationPart {
        @Comments(value={"https://bluemap.bluecolored.de/"})
        public boolean blueMap = false;
        @Comments(value={"https://www.spigotmc.org/resources/dynmap%C2%AE.274/"})
        public boolean dynmap = false;
    }

    public static class GroupTitle
    extends ConfigurationPart {
        public boolean enable = false;
        public String prefix = "[";
        public String suffix = "]";
    }

    public static class ExternalLinks
    extends ConfigurationPart {
        public String commandHelp = "";
        public String documentation = "https://dominion.lunadeer.cn/notes/doc/player/";
    }
}

