/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.managers;

import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Configuration;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.managers.TeleportManager;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scheduler.Scheduler;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class MultiServerManager
implements PluginMessageListener {
    public static MultiServerManager instance;
    private final JavaPlugin plugin;
    private final Map<Integer, String> serverMap = new HashMap<Integer, String>();

    public MultiServerManager(JavaPlugin plugin) {
        this.plugin = plugin;
        if (!Configuration.multiServer.enable) {
            return;
        }
        this.plugin.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, "BungeeCord");
        this.plugin.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this.plugin, "BungeeCord", (PluginMessageListener)this);
        instance = this;
        this.serverMap.put(Configuration.multiServer.serverId, Configuration.multiServer.serverName);
        XLogger.info(Language.multiServerManagerText.sendingNotice, Configuration.multiServer.serverId, Configuration.multiServer.serverName);
        Scheduler.runTaskRepeatAsync(this::sendNotice, 0L, 6000L);
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte @NotNull [] message) {
        if (!Configuration.multiServer.enable) {
            return;
        }
        if (!channel.equals("BungeeCord")) {
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
        String subChannel = in.readUTF();
        if (!subChannel.equals("dominion")) {
            return;
        }
        int serverId = in.readInt();
        if (serverId != Configuration.multiServer.serverId && serverId != -1) {
            return;
        }
        ACTION action = ACTION.valueOf(in.readUTF());
        switch (action) {
            case NOTICE: {
                this.handleNotice(in.readUTF(), in.readUTF());
                break;
            }
            case RESP_NOTICE: {
                this.handleRespNotice(in.readUTF(), in.readUTF());
                break;
            }
            case TELEPORT: {
                TeleportManager.handleTeleportBcMsg(in.readUTF(), in.readUTF());
            }
        }
    }

    public void sendActionMessage(Integer serverId, ACTION action, List<String> args) throws IOException {
        if (!Configuration.multiServer.enable) {
            return;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Forward");
        out.writeUTF("ALL");
        out.writeUTF("dominion");
        ByteArrayOutputStream msgbytes = new ByteArrayOutputStream();
        DataOutputStream msgout = new DataOutputStream(msgbytes);
        msgout.writeInt(serverId);
        msgout.writeUTF(action.name());
        for (String data : args) {
            msgout.writeUTF(data);
        }
        out.writeShort(msgbytes.toByteArray().length);
        out.write(msgbytes.toByteArray());
        this.plugin.getServer().sendPluginMessage((Plugin)this.plugin, "BungeeCord", out.toByteArray());
    }

    public void sendActionMessageAll(ACTION action, List<String> args) throws IOException {
        this.sendActionMessage(-1, action, args);
    }

    public void connectToServer(Player player, String serverName) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Connect");
        out.writeUTF(serverName);
        player.sendPluginMessage((Plugin)this.plugin, "BungeeCord", out.toByteArray());
    }

    private void sendNotice() {
        try {
            String serverId = "" + Configuration.multiServer.serverId;
            String serverName = Configuration.multiServer.serverName;
            this.sendActionMessageAll(ACTION.NOTICE, List.of(serverId, serverName));
        }
        catch (IOException e) {
            XLogger.error(e);
        }
    }

    private void handleNotice(String rcvServerId, String rcvServerName) {
        try {
            String thisServerId = "" + Configuration.multiServer.serverId;
            String thisServerName = Configuration.multiServer.serverName;
            int receivedServerId = Converts.toIntegrity(rcvServerId);
            if (!this.serverMap.containsKey(receivedServerId)) {
                this.serverMap.put(receivedServerId, rcvServerName);
                XLogger.info(Language.multiServerManagerText.receivedNotice, rcvServerId, rcvServerName, thisServerId, thisServerName);
            }
            this.sendActionMessage(receivedServerId, ACTION.RESP_NOTICE, List.of(thisServerId, thisServerName));
        }
        catch (Exception e) {
            XLogger.error(e);
        }
    }

    private void handleRespNotice(String rcvServerId, String rcvServerName) {
        try {
            int receivedServerId = Converts.toIntegrity(rcvServerId);
            if (!this.serverMap.containsKey(receivedServerId)) {
                XLogger.info(Language.multiServerManagerText.receivedNotice, rcvServerId, rcvServerName);
                this.serverMap.put(receivedServerId, rcvServerName);
                CacheManager.instance.addServerCache(receivedServerId);
            }
        }
        catch (Exception e) {
            XLogger.error(e);
        }
    }

    public Map<Integer, String> getServerMap() {
        return this.serverMap;
    }

    public String getServerName(int serverId) {
        return this.serverMap.get(serverId);
    }

    public Integer getServerId(String serverName) {
        return this.serverMap.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(serverName)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public static class MultiServerManagerText
    extends ConfigurationPart {
        public String sendingNotice = "Sending notice to all servers... ({0}:{1})";
        public String receivedNotice = "Received notice from server {0}:{1}, responding... ({2}:{3})";
        public String receiveRespNotice = "Received response notice from server {0}:{1}";
    }

    public static enum ACTION {
        NOTICE,
        RESP_NOTICE,
        TELEPORT;

    }
}

