/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.tuis.dominion.copy;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.commands.CopyCommand;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.tuis.dominion.copy.CopyMenu;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GroupCopy {
    public static ListViewButton button(final CommandSender sender, final String toDominionName) {
        return (ListViewButton)new ListViewButton(Language.groupCopyTuiText.button){

            @Override
            public void function(String pageStr) {
                GroupCopy.show(sender, toDominionName, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    public static void show(final CommandSender sender, final String toDominionName, String pageStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(toDominionName);
            Player player = Converts.toPlayer(sender);
            Asserts.assertDominionAdmin(sender, dominion);
            int page = Converts.toIntegrity(pageStr);
            ListView view = ListView.create(10, GroupCopy.button(sender, toDominionName));
            view.title(Language.groupCopyTuiText.title).navigator(Line.create().append(CopyMenu.button(sender, toDominionName).setText(Language.groupCopyTuiText.back).build()));
            List<DominionDTO> dominions = CacheManager.instance.getPlayerOwnDominionDTOs(player.getUniqueId());
            for (final DominionDTO fromDominion : dominions) {
                if (fromDominion.getId().equals(dominion.getId())) continue;
                view.add(Line.create().append(new FunctionalButton(Language.groupCopyTuiText.copy){

                    @Override
                    public void function() {
                        CopyCommand.copyGroup(sender, fromDominion.getName(), toDominionName);
                    }
                }.needPermission(Dominion.defaultPermission).build()).append(Component.text((String)fromDominion.getName())));
            }
            view.showOn(sender, page);
        }
        catch (Exception e) {
            Notification.error(sender, e.getMessage());
        }
    }

    public static class GroupCopyTuiText
    extends ConfigurationPart {
        public String title = "Select Dominion to Copy From";
        public String button = "GROUPS";
        public String copy = "COPY FROM";
        public String description = "Copy Group & Settings From Other Dominion.";
        public String back = "BACK";
    }
}

