/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.tuis.dominion.manage.group;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.GroupDTO;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.api.dtos.flag.PriFlag;
import cn.lunadeer.dominion.commands.GroupCommand;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.inputters.RenameGroupInputter;
import cn.lunadeer.dominion.uis.tuis.MainMenu;
import cn.lunadeer.dominion.uis.tuis.dominion.DominionList;
import cn.lunadeer.dominion.uis.tuis.dominion.DominionManage;
import cn.lunadeer.dominion.uis.tuis.dominion.manage.group.GroupList;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.command.CommandSender;

public class GroupSetting {
    public static ListViewButton button(final CommandSender sender, final String dominionName, final String groupName) {
        return (ListViewButton)new ListViewButton(Language.groupSettingTuiText.button){

            @Override
            public void function(String page) {
                GroupSetting.show(sender, dominionName, groupName, page);
            }
        }.needPermission(Dominion.defaultPermission).setHoverText(Language.groupSettingTuiText.description);
    }

    public static void show(CommandSender sender, String dominionName, String groupName, String pageStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            Asserts.assertDominionAdmin(sender, dominion);
            GroupDTO group = Converts.toGroupDTO(dominion, groupName);
            int page = Converts.toIntegrity(pageStr);
            ListView view = ListView.create(10, GroupSetting.button(sender, dominionName, groupName));
            view.title(Misc.formatString(Language.groupSettingTuiText.title, groupName));
            view.navigator(Line.create().append(MainMenu.button(sender).build()).append(DominionList.button(sender).build()).append(DominionManage.button(sender, dominionName).build()).append(GroupList.button(sender, dominionName).build()).append(Language.groupSettingTuiText.button));
            view.add(Line.create().append(RenameGroupInputter.createOn(sender, dominionName, groupName).build()));
            if (group.getFlagValue(Flags.ADMIN).booleanValue()) {
                view.add(GroupSetting.createOption(sender, Flags.ADMIN, true, dominion.getName(), group.getNamePlain(), pageStr));
                view.add(GroupSetting.createOption(sender, Flags.GLOW, group.getFlagValue(Flags.GLOW), dominion.getName(), group.getNamePlain(), pageStr));
            } else {
                for (PriFlag flag : Flags.getAllPriFlagsEnable()) {
                    view.add(GroupSetting.createOption(sender, flag, group.getFlagValue(flag), dominion.getName(), group.getNamePlain(), pageStr));
                }
            }
            view.showOn(sender, page);
        }
        catch (Exception e) {
            Notification.error(sender, e.getMessage());
        }
    }

    private static Line createOption(final CommandSender sender, final PriFlag flag, boolean value, final String DominionName, final String groupName, final String pageStr) {
        if (value) {
            return Line.create().append(new FunctionalButton("\u2611"){

                @Override
                public void function() {
                    GroupCommand.setGroupFlag(sender, DominionName, groupName, flag.getFlagName(), "false", pageStr);
                }
            }.needPermission(Dominion.defaultPermission).green().build()).append((TextComponent)Component.text((String)flag.getDisplayName()).hoverEvent((HoverEventSource)Component.text((String)flag.getDescription())));
        }
        return Line.create().append(new FunctionalButton("\u2610"){

            @Override
            public void function() {
                GroupCommand.setGroupFlag(sender, DominionName, groupName, flag.getFlagName(), "true", pageStr);
            }
        }.needPermission(Dominion.defaultPermission).red().build()).append((TextComponent)Component.text((String)flag.getDisplayName()).hoverEvent((HoverEventSource)Component.text((String)flag.getDescription())));
    }

    public static class GroupSettingTuiText
    extends ConfigurationPart {
        public String title = "Group {0} Settings";
        public String description = "Manage the settings of group {0}.";
        public String button = "SETTING";
    }
}

