/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.tuis.dominion.manage.group;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.commands.GroupCommand;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.doos.MemberDOO;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.tuis.dominion.manage.group.GroupList;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;

public class SelectMember {
    public static ListViewButton button(final CommandSender sender, final String dominionName, final String groupName, final String backPageStr) {
        return (ListViewButton)new ListViewButton("+"){

            @Override
            public void function(String page) {
                SelectMember.show(sender, dominionName, groupName, backPageStr, page);
            }
        }.needPermission(Dominion.defaultPermission).green().setHoverText(Language.selectMemberTuiText.description);
    }

    public static void show(final CommandSender sender, final String dominionName, final String groupName, final String backPageStr, String pageStr) {
        try {
            DominionDTO dominion = Converts.toDominionDTO(dominionName);
            Asserts.assertDominionAdmin(sender, dominion);
            int page = Converts.toIntegrity(pageStr);
            ListView view = ListView.create(10, SelectMember.button(sender, dominionName, groupName, backPageStr));
            view.title(Language.selectMemberTuiText.title);
            Line sub = Line.create().append(new FunctionalButton(Language.selectMemberTuiText.back){

                @Override
                public void function() {
                    GroupList.show(sender, dominionName, backPageStr);
                }
            }.needPermission(Dominion.defaultPermission).build());
            view.subtitle(sub);
            ArrayList<MemberDOO> members = new ArrayList<MemberDOO>(MemberDOO.selectByDominionId(dominion.getId()));
            for (MemberDTO memberDTO : members) {
                if (memberDTO.getGroupId() != -1) continue;
                final PlayerDTO p = Converts.toPlayerDTO(memberDTO.getPlayerUUID());
                view.add(Line.create().append(new FunctionalButton(p.getLastKnownName()){

                    @Override
                    public void function() {
                        GroupCommand.addMember(sender, dominionName, groupName, p.getLastKnownName());
                    }
                }.needPermission(Dominion.defaultPermission).build()));
            }
            view.showOn(sender, page);
        }
        catch (Exception e) {
            Notification.error(sender, e.getMessage());
        }
    }

    public static class SelectMemberTuiText
    extends ConfigurationPart {
        public String title = "Select Member";
        public String description = "Select a member to add to the group.";
        public String back = "BACK";
    }
}

