/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils;

import java.util.Comparator;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class SafeLocationFinder {
    public static Location findNearestSafeLocation(Location originalLocation) {
        World world = originalLocation.getWorld();
        if (world == null) {
            return originalLocation.clone();
        }
        PriorityQueue<BlockPosition> queue = new PriorityQueue<BlockPosition>(Comparator.comparingDouble(b -> SafeLocationFinder.distanceSquared(b, originalLocation)));
        HashSet<BlockPosition> visited = new HashSet<BlockPosition>();
        BlockPosition initialFoot = new BlockPosition((int)Math.floor(originalLocation.getX()), (int)Math.floor(originalLocation.getY()) - 1, (int)Math.floor(originalLocation.getZ()));
        queue.add(initialFoot);
        visited.add(initialFoot);
        while (!queue.isEmpty()) {
            BlockPosition current = queue.poll();
            Block footBlock = world.getBlockAt(current.x, current.y, current.z);
            if (!footBlock.getType().isSolid()) continue;
            Location playerLoc = new Location(world, (double)current.x + 0.5, (double)(current.y + 1), (double)current.z + 0.5);
            if (SafeLocationFinder.isSafeLocation(playerLoc)) {
                return playerLoc;
            }
            SafeLocationFinder.addNeighbors(current, queue, visited, world);
        }
        return originalLocation.clone();
    }

    private static boolean isSafeLocation(Location location) {
        Block footBlock = location.clone().subtract(0.0, 1.0, 0.0).getBlock();
        if (!footBlock.getType().isSolid()) {
            return false;
        }
        Block currentBlock = location.getBlock();
        Material currentType = currentBlock.getType();
        if (currentType == Material.WATER || currentType == Material.LAVA || currentBlock.getType().isSolid()) {
            return false;
        }
        Block headBlock = location.clone().add(0.0, 1.0, 0.0).getBlock();
        Material headType = headBlock.getType();
        return headType != Material.WATER && headType != Material.LAVA && !headBlock.getType().isSolid();
    }

    private static void addNeighbors(BlockPosition pos, PriorityQueue<BlockPosition> queue, Set<BlockPosition> visited, World world) {
        int[][] directions;
        for (int[] dir : directions = new int[][]{{1, 0, 0}, {-1, 0, 0}, {0, 1, 0}, {0, -1, 0}, {0, 0, 1}, {0, 0, -1}}) {
            BlockPosition neighbor;
            int nx = pos.x + dir[0];
            int ny = pos.y + dir[1];
            int nz = pos.z + dir[2];
            if (ny < world.getMinHeight() || ny >= world.getMaxHeight() || visited.contains(neighbor = new BlockPosition(nx, ny, nz))) continue;
            visited.add(neighbor);
            queue.add(neighbor);
        }
    }

    private static double distanceSquared(BlockPosition blockPos, Location original) {
        double px = (double)blockPos.x + 0.5;
        double py = blockPos.y + 1;
        double pz = (double)blockPos.z + 0.5;
        return Math.pow(px - original.getX(), 2.0) + Math.pow(py - original.getY(), 2.0) + Math.pow(pz - original.getZ(), 2.0);
    }

    private record BlockPosition(int x, int y, int z) {
    }
}

