/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.command;

import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.command.Argument;
import cn.lunadeer.dominion.utils.command.ConditionalArgument;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandManager
implements TabExecutor,
Listener {
    private static String rootCommand;
    private final JavaPlugin plugin;
    private Consumer<CommandSender> rootCommandConsumer = null;
    private static final Map<String, SecondaryCommand> commands;
    private static final Map<String, SecondaryCommand> commandsUsable;

    public CommandManager(JavaPlugin plugin, String rootCommand) {
        CommandManager.rootCommand = "/" + rootCommand;
        Objects.requireNonNull(Bukkit.getPluginCommand((String)rootCommand)).setExecutor((CommandExecutor)this);
        XLogger.debug("Registered {0} commands.", commands.size());
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin = plugin;
    }

    public CommandManager(JavaPlugin plugin, String rootCommand, Consumer<CommandSender> rootCommandConsumer) {
        CommandManager.rootCommand = "/" + rootCommand;
        Objects.requireNonNull(Bukkit.getPluginCommand((String)rootCommand)).setExecutor((CommandExecutor)this);
        XLogger.debug("Registered {0} commands.", commands.size());
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin = plugin;
        this.rootCommandConsumer = rootCommandConsumer;
    }

    public void printUsages() {
        for (String cmd : commandsUsable.keySet()) {
            XLogger.debug("{0}", commands.get(cmd).getUsage());
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.plugin.getServer().getOnlinePlayers().isEmpty()) {
            for (String cmd : commands.keySet()) {
                if (!commands.get(cmd).isHideUsage()) continue;
                XLogger.debug("Due to no one online, Unregistering command: {0}", cmd);
                CommandManager.unregisterCommand(cmd);
            }
        }
    }

    public static String getRootCommand() {
        return rootCommand;
    }

    public static void registerCommand(SecondaryCommand command) {
        commands.put(command.getCommand(), command);
        if (!command.isHideUsage()) {
            commandsUsable.put(command.getCommand(), command);
        }
    }

    public static void unregisterCommand(SecondaryCommand command) {
        commands.remove(command.getCommand());
        commandsUsable.remove(command.getCommand());
    }

    public static void unregisterCommand(String command) {
        commands.remove(command);
        commandsUsable.remove(command);
    }

    public static SecondaryCommand getCommand(String command) {
        return commands.get(command);
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        if (strings.length == 0) {
            if (this.rootCommandConsumer != null) {
                try {
                    this.rootCommandConsumer.accept(commandSender);
                }
                catch (Exception e) {
                    Notification.error(commandSender, e.getMessage());
                }
            }
            return true;
        }
        SecondaryCommand cmd = CommandManager.getCommand(strings[0]);
        if (cmd == null) {
            return true;
        }
        try {
            cmd.run(commandSender, strings);
        }
        catch (Exception e) {
            Notification.error(commandSender, e.getMessage());
            XLogger.error(e);
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        if (strings.length == 1) {
            return new ArrayList<String>(commandsUsable.keySet().stream().filter(cmd -> cmd.startsWith(strings[0])).toList());
        }
        SecondaryCommand cmd2 = CommandManager.getCommand(strings[0]);
        if (cmd2 == null) {
            return null;
        }
        List<Argument> args = cmd2.getArguments();
        if (strings.length - 1 > args.size()) {
            return null;
        }
        for (int i = 1; i < strings.length - 1; ++i) {
            args.get(i - 1).setValue(strings[i]);
        }
        for (Argument arg : args) {
            if (!(arg instanceof ConditionalArgument)) continue;
            ConditionalArgument cond = (ConditionalArgument)arg;
            for (Integer key : cond.getConditionArguments().keySet()) {
                if (key >= strings.length - 2) continue;
                cond.setConditionArguments(key, strings[key + 1]);
            }
        }
        return args.get(strings.length - 2).getSuggestion().get(commandSender);
    }

    static {
        commands = new HashMap<String, SecondaryCommand>();
        commandsUsable = new HashMap<String, SecondaryCommand>();
    }
}

