/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils.webMap;

import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.configuration.Language;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.XLogger;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scheduler.Scheduler;
import com.flowpowered.math.vector.Vector2d;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.markers.ExtrudeMarker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Shape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BlueMapConnect {
    public static void render() {
        Scheduler.runTaskAsync(() -> {
            try {
                BlueMapAPI.getInstance().ifPresent(api -> {
                    HashMap world_dominions = new HashMap();
                    for (DominionDTO dominionDTO : CacheManager.instance.getCache().getDominionCache().getAllDominions()) {
                        if (dominionDTO.getWorld() == null) continue;
                        if (!world_dominions.containsKey(dominionDTO.getWorld().getName())) {
                            world_dominions.put(dominionDTO.getWorld().getName(), new ArrayList());
                        }
                        ((List)world_dominions.get(dominionDTO.getWorld().getName())).add(dominionDTO);
                    }
                    for (Map.Entry entry : world_dominions.entrySet()) {
                        api.getWorld(entry.getKey()).ifPresent(world -> {
                            MarkerSet markerSet = MarkerSet.builder().label("Dominion").build();
                            for (DominionDTO dominion : (List)d.getValue()) {
                                PlayerDTO p = CacheManager.instance.getPlayer(dominion.getOwner());
                                if (p == null) continue;
                                ArrayList<Vector2d> vectors = new ArrayList<Vector2d>();
                                vectors.add(new Vector2d((double)dominion.getCuboid().x1() + 0.001, (double)dominion.getCuboid().z1() + 0.001));
                                vectors.add(new Vector2d((double)dominion.getCuboid().x2() - 0.001, (double)dominion.getCuboid().z1() + 0.001));
                                vectors.add(new Vector2d((double)dominion.getCuboid().x2() - 0.001, (double)dominion.getCuboid().z2() - 0.001));
                                vectors.add(new Vector2d((double)dominion.getCuboid().x1() + 0.001, (double)dominion.getCuboid().z2() - 0.001));
                                Shape shape = new Shape(vectors);
                                double x = ((Vector2d)vectors.iterator().next()).getX();
                                double z = ((Vector2d)vectors.iterator().next()).getY();
                                double y = dominion.getCuboid().y1();
                                int r = dominion.getColorR();
                                int g = dominion.getColorG();
                                int b = dominion.getColorB();
                                Color line = new Color(r, g, b, 0.8f);
                                Color fill = new Color(r, g, b, 0.2f);
                                ExtrudeMarker marker = ((ExtrudeMarker.Builder)((ExtrudeMarker.Builder)((ExtrudeMarker.Builder)ExtrudeMarker.builder().label(dominion.getName())).detail(Misc.formatString(Language.blueMapConnectText.infoLabel, dominion.getName(), p.getLastKnownName()))).position(x, y, z)).shape(shape, (float)dominion.getCuboid().y1() + 0.001f, (float)dominion.getCuboid().y2() - 0.001f).lineColor(line).fillColor(fill).build();
                                markerSet.getMarkers().put(dominion.getName(), marker);
                            }
                            for (BlueMapMap map : world.getMaps()) {
                                map.getMarkerSets().put((String)d.getKey() + "-" + markerSet.getLabel(), markerSet);
                            }
                        });
                    }
                });
            }
            catch (NoClassDefFoundError e) {
                XLogger.warn(Language.blueMapConnectText.registerFail);
                XLogger.error(e);
            }
        });
    }

    public static void renderMCA(Map<String, List<String>> mca_files) {
        Scheduler.runTaskAsync(() -> {
            try {
                BlueMapAPI.getInstance().ifPresent(api -> {
                    for (String world : mca_files.keySet()) {
                        api.getWorld((Object)world).ifPresent(bmWorld -> {
                            MarkerSet markerSet = MarkerSet.builder().label("MCA").defaultHidden(Boolean.valueOf(true)).build();
                            for (String file : (List)mca_files.get(world)) {
                                int mca_x = Integer.parseInt(file.split("\\.")[1]);
                                int mca_z = Integer.parseInt(file.split("\\.")[2]);
                                int world_x1 = mca_x * 512;
                                int world_x2 = (mca_x + 1) * 512;
                                int world_z1 = mca_z * 512;
                                int world_z2 = (mca_z + 1) * 512;
                                ArrayList<Vector2d> vectors = new ArrayList<Vector2d>();
                                vectors.add(new Vector2d((double)world_x1 + 0.001, (double)world_z1 + 0.001));
                                vectors.add(new Vector2d((double)world_x2 - 0.001, (double)world_z1 + 0.001));
                                vectors.add(new Vector2d((double)world_x2 - 0.001, (double)world_z2 - 0.001));
                                vectors.add(new Vector2d((double)world_x1 + 0.001, (double)world_z2 - 0.001));
                                Shape shape = new Shape(vectors);
                                double x = ((Vector2d)vectors.iterator().next()).getX();
                                double z = ((Vector2d)vectors.iterator().next()).getY();
                                double y = -64.0;
                                Color line = new Color(0, 204, 0, 0.8f);
                                Color fill = new Color(0, 204, 0, 0.2f);
                                ExtrudeMarker marker = ((ExtrudeMarker.Builder)((ExtrudeMarker.Builder)ExtrudeMarker.builder().label(file)).position(x, y, z)).shape(shape, -64.0f, 320.0f).lineColor(line).fillColor(fill).build();
                                markerSet.getMarkers().put(file, marker);
                            }
                            for (BlueMapMap map : bmWorld.getMaps()) {
                                map.getMarkerSets().put(world + "-" + markerSet.getLabel(), markerSet);
                            }
                        });
                    }
                });
            }
            catch (NoClassDefFoundError e) {
                XLogger.warn(Language.blueMapConnectText.registerFail);
                XLogger.error(e);
            }
        });
    }

    public static class BlueMapConnectText
    extends ConfigurationPart {
        public String registerFail = "Failed to register BlueMap API.";
        public String infoLabel = "<div>{0}</div><div>Owner: {1}</div>";
    }
}

