/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis;

import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.XLogger;
import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class AbstractUI {
    protected abstract void showTUI(Player var1, String ... var2) throws Exception;

    protected abstract void showCUI(Player var1, String ... var2) throws Exception;

    protected void displayByPreference(CommandSender sender, String ... args) {
        try {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                PlayerDTO playerDTO = CacheManager.instance.getPlayer(player.getUniqueId());
                if (playerDTO == null) {
                    this.showTUI(player, args);
                    XLogger.warn("PlayerDTO not found for player: " + player.getName() + ". Showing TUI instead.");
                    return;
                }
                if (Objects.requireNonNull(playerDTO.getUiPreference()) == PlayerDTO.UI_TYPE.CUI) {
                    this.showCUI(player, args);
                } else {
                    this.showTUI(player, args);
                }
            }
        }
        catch (Exception e) {
            Notification.error(sender, e);
        }
    }
}

