/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.dominion;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.cache.CacheManager;
import cn.lunadeer.dominion.cache.DominionNode;
import cn.lunadeer.dominion.commands.DominionOperateCommand;
import cn.lunadeer.dominion.configuration.uis.ChestUserInterface;
import cn.lunadeer.dominion.configuration.uis.TextUserInterface;
import cn.lunadeer.dominion.managers.TeleportManager;
import cn.lunadeer.dominion.misc.CommandArguments;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.MainMenu;
import cn.lunadeer.dominion.uis.dominion.DominionManage;
import cn.lunadeer.dominion.utils.Notification;
import cn.lunadeer.dominion.utils.command.SecondaryCommand;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestListView;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.scui.configuration.ListViewConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.ViewStyles;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class DominionList
extends AbstractUI {
    public static SecondaryCommand list = new SecondaryCommand("list", List.of(new CommandArguments.OptionalPageArgument())){

        @Override
        public void executeHandler(CommandSender sender) {
            try {
                DominionList.show(sender, this.getArgumentValue(0));
            }
            catch (Exception e) {
                Notification.error(sender, e.getMessage());
            }
        }
    }.needPermission(Dominion.defaultPermission).register();

    public static void show(CommandSender sender, String pageStr) {
        new DominionList().displayByPreference(sender, pageStr);
    }

    public static ListViewButton button(final CommandSender sender) {
        return (ListViewButton)new ListViewButton(TextUserInterface.dominionListTuiText.button){

            @Override
            public void function(String pageStr) {
                DominionList.show(sender, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    public static List<Line> BuildTreeLines(final CommandSender sender, List<DominionNode> dominionTree, Integer depth) {
        ArrayList<Line> lines = new ArrayList<Line>();
        StringBuilder prefix = new StringBuilder();
        prefix.append(" | ".repeat(Math.max(0, depth)));
        for (final DominionNode node : dominionTree) {
            TextComponent manage = DominionManage.button(sender, node.getDominion().getName()).green().build();
            TextComponent delete = new FunctionalButton(TextUserInterface.dominionListTuiText.deleteButton){

                @Override
                public void function() {
                    DominionOperateCommand.delete(sender, node.getDominion().getName(), "");
                }
            }.red().build();
            TextComponent tp = new FunctionalButton("TP"){

                @Override
                public void function() {
                    if (sender instanceof Player) {
                        Player player = (Player)sender;
                        TeleportManager.teleportToDominion(player, node.getDominion());
                    }
                }
            }.build();
            Line line = Line.create().append(delete).append(manage).append(tp).append(String.valueOf(prefix) + node.getDominion().getName());
            lines.add(line);
            lines.addAll(DominionList.BuildTreeLines(sender, node.getChildren(), depth + 1));
        }
        return lines;
    }

    @Override
    protected void showTUI(Player player, String ... args) throws Exception {
        int page = Converts.toIntegrity(args[0], 1);
        ListView view = ListView.create(10, DominionList.button((CommandSender)player));
        view.title(TextUserInterface.dominionListTuiText.title);
        view.navigator(Line.create().append(MainMenu.button((CommandSender)player).build()).append(TextUserInterface.dominionListTuiText.button));
        CopyOnWriteArrayList<DominionNode> dominionNodes = CacheManager.instance.getCache().getDominionCache().getPlayerDominionNodes(player.getUniqueId());
        view.addLines(DominionList.BuildTreeLines((CommandSender)player, dominionNodes, 0));
        List<DominionDTO> admin_dominions = CacheManager.instance.getCache().getDominionCache().getPlayerAdminDominionDTOs(player.getUniqueId());
        if (!admin_dominions.isEmpty()) {
            view.add(Line.create().append(""));
            view.add(Line.create().append(Component.text((String)TextUserInterface.dominionListTuiText.adminSection, (TextColor)ViewStyles.PRIMARY)));
            for (DominionDTO dominion : admin_dominions) {
                TextComponent manage = DominionManage.button((CommandSender)player, dominion.getName()).build();
                view.add(Line.create().append(manage).append(dominion.getName()));
            }
        }
        view.showOn(player, page);
    }

    @Override
    protected void showCUI(final Player player, String ... args) {
        ChestListView view = ChestUserInterfaceManager.getInstance().getListViewOf(player);
        view.setTitle(ChestUserInterface.dominionListCui.title);
        view.applyListConfiguration(ChestUserInterface.dominionListCui.listConfiguration, Converts.toIntegrity(args[0]));
        CopyOnWriteArrayList<DominionDTO> own = CacheManager.instance.getCache().getDominionCache().getPlayerOwnDominionDTOs(player.getUniqueId());
        for (final DominionDTO dominion : own) {
            ChestButton btn = new ChestButton(ChestUserInterface.dominionListCui.ownDominionButton){

                @Override
                public void onClick(ClickType type) {
                    DominionManage.show((CommandSender)player, dominion.getName(), "1");
                }
            };
            btn = btn.setDisplayNameArgs(dominion.getName());
            view = view.addItem(btn);
        }
        List<DominionDTO> admin = CacheManager.instance.getCache().getDominionCache().getPlayerAdminDominionDTOs(player.getUniqueId());
        for (final DominionDTO dominion : admin) {
            ChestButton btn = new ChestButton(ChestUserInterface.dominionListCui.adminDominionButton){

                @Override
                public void onClick(ClickType type) {
                    if (type.isLeftClick()) {
                        DominionManage.show((CommandSender)player, dominion.getName(), "1");
                    } else if (type.isRightClick()) {
                        TeleportManager.teleportToDominion(player, dominion);
                    }
                }
            };
            btn = btn.setDisplayNameArgs(dominion.getName());
            btn = btn.setLoreArgs(List.of(dominion.getOwnerDTO().getLastKnownName()));
            view = view.addItem(btn);
        }
        view.setButton(ChestUserInterface.dominionListCui.backButton.getSymbol(), new ChestButton(ChestUserInterface.dominionListCui.backButton){

            @Override
            public void onClick(ClickType type) {
                MainMenu.show((CommandSender)player, "1");
            }
        });
        view.open();
    }

    public static class DominionListTuiText
    extends ConfigurationPart {
        public String title = "Your Dominions";
        public String button = "DOMINIONS";
        public String description = "List all of your dominions.";
        public String deleteButton = "DELETE";
        public String adminSection = "Your admin dominions section.";
        public String serverSection = "Server {0} dominions section.";
    }

    public static class DominionListCui
    extends ConfigurationPart {
        public String title = "\u00a76\u2726 \u00a7b\u00a7lDominions List \u00a76\u2726";
        public ListViewConfiguration listConfiguration = new ListViewConfiguration('i', List.of("<########", "#iiiiiii#", "#iiiiiii#", "#iiiiiii#", "p#######n"));
        public ButtonConfiguration ownDominionButton = ButtonConfiguration.createMaterial('i', Material.GRASS_BLOCK, "\u00a72\ud83d\udc51 \u00a7a{0}", List.of("\u00a77This is \u00a7ayour dominion\u00a77.", "\u00a78You have full control here!", "", "\u00a7a\u25b6 Left Click: manage", "\u00a78  Settings, members, permissions", "\u00a7b\u25b6 Right Click: teleport", "", "\u00a77Status: \u00a72Owner"));
        public ButtonConfiguration adminDominionButton = ButtonConfiguration.createMaterial('i', Material.DIRT_PATH, "\u00a79\u26a1 \u00a7b{0}", List.of("\u00a77Owner: \u00a7e{0}", "\u00a78You have admin access here.", "", "\u00a7b\u25b6 Left Click: manage", "\u00a78  Help the owner manage this dominion", "\u00a7b\u25b6 Right Click: teleport", "", "\u00a77Status: \u00a79Administrator"));
        public ButtonConfiguration backButton = ButtonConfiguration.createMaterial('<', Material.RED_STAINED_GLASS_PANE, "\u00a7c\u00ab Back to Main Menu", List.of("\u00a77Return to the main menu", "\u00a78to access other features.", "", "\u00a7e\u25b6 Click to go back"));
    }
}

