/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.dominion.manage.group;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.MemberDTO;
import cn.lunadeer.dominion.api.dtos.PlayerDTO;
import cn.lunadeer.dominion.commands.GroupCommand;
import cn.lunadeer.dominion.configuration.uis.ChestUserInterface;
import cn.lunadeer.dominion.configuration.uis.TextUserInterface;
import cn.lunadeer.dominion.doos.MemberDOO;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.dominion.manage.group.GroupList;
import cn.lunadeer.dominion.uis.dominion.manage.group.GroupManage;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestListView;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.scui.configuration.ListViewConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class SelectMember
extends AbstractUI {
    public static void show(CommandSender sender, String dominionName, String groupName, String backPageStr, String pageStr) {
        new SelectMember().displayByPreference(sender, dominionName, groupName, backPageStr, pageStr);
    }

    public static ListViewButton button(final CommandSender sender, final String dominionName, final String groupName, final String backPageStr) {
        return (ListViewButton)new ListViewButton("+"){

            @Override
            public void function(String page) {
                SelectMember.show(sender, dominionName, groupName, backPageStr, page);
            }
        }.needPermission(Dominion.defaultPermission).green().setHoverText(TextUserInterface.selectMemberTuiText.description);
    }

    @Override
    protected void showTUI(final Player player, String ... args) throws Exception {
        final String dominionName = args[0];
        final String groupName = args[1];
        final String backPageStr = args[2];
        String pageStr = args[3];
        DominionDTO dominion = Converts.toDominionDTO(dominionName);
        Asserts.assertDominionAdmin(player, dominion);
        int page = Converts.toIntegrity(pageStr);
        ListView view = ListView.create(10, SelectMember.button((CommandSender)player, dominionName, groupName, backPageStr));
        view.title(TextUserInterface.selectMemberTuiText.title);
        Line sub = Line.create().append(new FunctionalButton(TextUserInterface.selectMemberTuiText.back){

            @Override
            public void function() {
                GroupList.show((CommandSender)player, dominionName, backPageStr);
            }
        }.needPermission(Dominion.defaultPermission).build());
        view.subtitle(sub);
        ArrayList<MemberDOO> members = new ArrayList<MemberDOO>(MemberDOO.selectByDominionId(dominion.getId()));
        for (MemberDTO memberDTO : members) {
            if (memberDTO.getGroupId() != -1) continue;
            final PlayerDTO p = Converts.toPlayerDTO(memberDTO.getPlayerUUID());
            view.add(Line.create().append(new FunctionalButton(p.getLastKnownName()){

                @Override
                public void function() {
                    GroupCommand.addMember((CommandSender)player, dominionName, groupName, p.getLastKnownName());
                }
            }.needPermission(Dominion.defaultPermission).build()));
        }
        view.showOn(player, page);
    }

    @Override
    protected void showCUI(final Player player, String ... args) throws Exception {
        final String dominionName = args[0];
        final String groupName = args[1];
        final String backPageStr = args[2];
        DominionDTO dominion = Converts.toDominionDTO(dominionName);
        Asserts.assertDominionAdmin(player, dominion);
        ChestListView view = ChestUserInterfaceManager.getInstance().getListViewOf(player);
        view.setTitle(Misc.formatString(ChestUserInterface.selectMemberCui.title, groupName));
        view.applyListConfiguration(ChestUserInterface.selectMemberCui.listConfiguration, Converts.toIntegrity(args[3]));
        view.setButton(ChestUserInterface.selectMemberCui.backButton.getSymbol(), new ChestButton(ChestUserInterface.selectMemberCui.backButton){

            @Override
            public void onClick(ClickType type) {
                GroupList.show((CommandSender)player, dominionName, backPageStr);
            }
        });
        ArrayList<MemberDOO> members = new ArrayList<MemberDOO>(MemberDOO.selectByDominionId(dominion.getId()));
        for (MemberDTO memberDTO : members) {
            if (memberDTO.getGroupId() != -1) continue;
            final PlayerDTO p = Converts.toPlayerDTO(memberDTO.getPlayerUUID());
            ButtonConfiguration item = ButtonConfiguration.createHeadByName(ChestUserInterface.selectMemberCui.listConfiguration.itemSymbol.charAt(0), p.getLastKnownName(), ChestUserInterface.selectMemberCui.memberItemName, ChestUserInterface.selectMemberCui.memberItemLore);
            ChestButton memberChest = new ChestButton(item){

                @Override
                public void onClick(ClickType type) {
                    GroupCommand.addMember((CommandSender)player, dominionName, groupName, p.getLastKnownName());
                    GroupManage.show((CommandSender)player, dominionName, groupName, "1");
                }
            }.setDisplayNameArgs(p.getLastKnownName()).setLoreArgs(p.getLastKnownName());
            view.addItem(memberChest);
        }
        view.open();
    }

    public static class SelectMemberTuiText
    extends ConfigurationPart {
        public String title = "Select Member";
        public String description = "Select a member to add to the group.";
        public String back = "BACK";
    }

    public static class SelectMemberCui
    extends ConfigurationPart {
        public String title = "\u00a76\u2726 \u00a75\u00a7lSelect Member for Group {0} \u00a76\u2726";
        public ListViewConfiguration listConfiguration = new ListViewConfiguration('i', List.of("<########", "#iiiiiii#", "#iiiiiii#", "#iiiiiii#", "p#######n"));
        public ButtonConfiguration backButton = ButtonConfiguration.createMaterial('<', Material.RED_STAINED_GLASS_PANE, "\u00a7c\u00ab Back to Group Manage", List.of("\u00a77Return to the group manage", "\u00a77without selecting a member.", "", "\u00a7e\u25b6 Click to go back"));
        public String memberItemName = "\u00a7a\u2795 \u00a72{0}";
        public List<String> memberItemLore = List.of("\u00a77Add this member to the group.", "", "\u00a77Player: \u00a7e{0}", "", "\u00a72\u25b6 Click to add to group", "", "\u00a78This member is not in any group.");
    }
}

