/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils;

import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.Notification;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class XLogger {
    public static XLogger instance;
    private final ConsoleCommandSender sender;
    private boolean debug = false;

    public XLogger(@NotNull JavaPlugin plugin) {
        instance = this;
        this.sender = plugin.getServer().getConsoleSender();
    }

    public static XLogger setDebug(boolean debug) {
        XLogger.instance.debug = debug;
        return instance;
    }

    public static boolean isDebug() {
        return XLogger.instance.debug;
    }

    public static void info(String message) {
        Notification.info((CommandSender)XLogger.instance.sender, "&a I | " + message);
    }

    public static void warn(String message) {
        Notification.warn((CommandSender)XLogger.instance.sender, "&e W | " + message);
    }

    public static void error(String message) {
        Notification.error((CommandSender)XLogger.instance.sender, "&c E | " + message);
    }

    public static void debug(String message) {
        if (!XLogger.instance.debug) {
            return;
        }
        Notification.info((CommandSender)XLogger.instance.sender, "&9 D | " + message);
    }

    public static void info(String message, Object ... args) {
        XLogger.info(Misc.formatString(message, args));
    }

    public static void warn(String message, Object ... args) {
        XLogger.warn(Misc.formatString(message, args));
    }

    public static void error(String message, Object ... args) {
        XLogger.error(Misc.formatString(message, args));
    }

    public static void error(Throwable e) {
        XLogger.error(e.getMessage());
        if (XLogger.isDebug()) {
            for (StackTraceElement element : e.getStackTrace()) {
                XLogger.error("StackTrace | " + element.toString());
            }
        }
    }

    public static void debug(String message, Object ... args) {
        XLogger.debug(Misc.formatString(message, args));
    }
}

