/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.utils;

import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.SendMessageAbstract;
import cn.lunadeer.dominion.utils.XLogger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class Notification {
    public static Notification instance;
    public final SendMessageAbstract sender;
    private static final Style i_style;
    private static final Style w_style;
    private static final Style e_style;
    private static final Style d_style;
    private String prefix;
    private JavaPlugin plugin;

    public Notification(JavaPlugin plugin) {
        instance = this;
        this.plugin = plugin;
        this.prefix = "[" + plugin.getName() + "]";
        this.sender = new SendMessageAbstract(plugin);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public static void info(Player player, String msg) {
        Notification.instance.sender.sendMessage(player, (Component)Component.text((String)(Notification.instance.prefix + " " + msg), (Style)i_style));
    }

    public static void info(Player player, String msg, Object ... args) {
        Notification.instance.sender.sendMessage(player, (Component)Component.text((String)(Notification.instance.prefix + " " + Misc.formatString(msg, args)), (Style)i_style));
    }

    public static void warn(Player player, String msg) {
        Notification.instance.sender.sendMessage(player, (Component)Component.text((String)(Notification.instance.prefix + " " + msg), (Style)w_style));
    }

    public static void warn(Player player, String msg, Object ... args) {
        Notification.instance.sender.sendMessage(player, (Component)Component.text((String)(Notification.instance.prefix + " " + Misc.formatString(msg, args)), (Style)w_style));
    }

    public static void error(Player player, String msg) {
        Notification.instance.sender.sendMessage(player, (Component)Component.text((String)(Notification.instance.prefix + " " + msg), (Style)e_style));
    }

    public static void error(Player player, String msg, Object ... args) {
        Notification.instance.sender.sendMessage(player, (Component)Component.text((String)(Notification.instance.prefix + " " + Misc.formatString(msg, args)), (Style)e_style));
    }

    public static void info(CommandSender sender, String msg) {
        Notification.instance.sender.sendMessage(sender, (Component)Component.text((String)(Notification.instance.prefix + " " + msg), (Style)i_style));
    }

    public static void info(CommandSender sender, String msg, Object ... args) {
        Notification.instance.sender.sendMessage(sender, (Component)Component.text((String)(Notification.instance.prefix + " " + Misc.formatString(msg, args)), (Style)i_style));
    }

    public static void warn(CommandSender sender, String msg) {
        Notification.instance.sender.sendMessage(sender, (Component)Component.text((String)(Notification.instance.prefix + " " + msg), (Style)w_style));
    }

    public static void warn(CommandSender sender, String msg, Object ... args) {
        Notification.instance.sender.sendMessage(sender, (Component)Component.text((String)(Notification.instance.prefix + " " + Misc.formatString(msg, args)), (Style)w_style));
    }

    public static void error(CommandSender sender, String msg) {
        Notification.instance.sender.sendMessage(sender, (Component)Component.text((String)(Notification.instance.prefix + " " + msg), (Style)e_style));
    }

    public static void error(CommandSender sender, String msg, Object ... args) {
        Notification.instance.sender.sendMessage(sender, (Component)Component.text((String)(Notification.instance.prefix + " " + Misc.formatString(msg, args)), (Style)e_style));
    }

    public static void info(Player player, Component msg) {
        Notification.instance.sender.sendMessage(player, ((TextComponent)Component.text((String)Notification.instance.prefix, (Style)i_style).append((Component)Component.text((String)" "))).append(msg));
    }

    public static void warn(Player player, Component msg) {
        Notification.instance.sender.sendMessage(player, ((TextComponent)Component.text((String)Notification.instance.prefix, (Style)w_style).append((Component)Component.text((String)" "))).append(msg));
    }

    public static void error(Player player, Component msg) {
        Notification.instance.sender.sendMessage(player, ((TextComponent)Component.text((String)Notification.instance.prefix, (Style)e_style).append((Component)Component.text((String)" "))).append(msg));
    }

    public static void info(CommandSender player, Component msg) {
        Notification.instance.sender.sendMessage(player, ((TextComponent)Component.text((String)Notification.instance.prefix, (Style)i_style).append((Component)Component.text((String)" "))).append(msg));
    }

    public static void warn(CommandSender player, Component msg) {
        Notification.instance.sender.sendMessage(player, ((TextComponent)Component.text((String)Notification.instance.prefix, (Style)w_style).append((Component)Component.text((String)" "))).append(msg));
    }

    public static void error(CommandSender player, Component msg) {
        Notification.instance.sender.sendMessage(player, ((TextComponent)Component.text((String)Notification.instance.prefix, (Style)e_style).append((Component)Component.text((String)" "))).append(msg));
    }

    public static void error(CommandSender player, Throwable e) {
        Notification.error(player, e.getMessage());
        if (XLogger.isDebug()) {
            XLogger.error(e);
        }
    }

    public static void all(String msg) {
        Notification.instance.sender.broadcast((Component)Component.text((String)(Notification.instance.prefix + " " + msg), (Style)i_style));
    }

    public static void all(Component msg) {
        Notification.instance.sender.broadcast(((TextComponent)Component.text((String)Notification.instance.prefix, (Style)i_style).append((Component)Component.text((String)" "))).append(msg));
    }

    public static void all(String msg, Object ... args) {
        Notification.instance.sender.broadcast((Component)Component.text((String)(Notification.instance.prefix + " " + Misc.formatString(msg, args)), (Style)i_style));
    }

    public static void actionBar(Player player, String msg) {
        Notification.instance.sender.sendActionBar(player, (Component)Component.text((String)msg));
    }

    public static void actionBar(Player player, String msg, Object ... args) {
        Notification.instance.sender.sendActionBar(player, (Component)Component.text((String)Misc.formatString(msg, args)));
    }

    public static void actionBar(Player player, Component msg) {
        Notification.instance.sender.sendActionBar(player, msg);
    }

    public static void title(Player player, String title) {
        Notification.instance.sender.sendTitle(player, (Component)Component.text((String)title), (Component)Component.empty());
    }

    public static void title(Player player, String title, String subtitle) {
        Notification.instance.sender.sendTitle(player, (Component)Component.text((String)title), (Component)Component.text((String)subtitle));
    }

    public static void title(Player player, Component title) {
        Notification.instance.sender.sendTitle(player, title, (Component)Component.empty());
    }

    public static void subTitle(Player player, Component subtitle) {
        Notification.instance.sender.sendTitle(player, (Component)Component.empty(), subtitle);
    }

    public static void subTitle(Player player, String subtitle) {
        Notification.instance.sender.sendTitle(player, (Component)Component.empty(), (Component)Component.text((String)subtitle));
    }

    public static void bossBar(Player player, String message) {
        Notification.instance.sender.sendBossBar(player, (Component)Component.text((String)message));
    }

    public static void bossBar(Player player, Component message) {
        Notification.instance.sender.sendBossBar(player, message);
    }

    static {
        i_style = Style.style((TextColor)TextColor.color((int)139, (int)255, (int)123));
        w_style = Style.style((TextColor)TextColor.color((int)255, (int)185, (int)69));
        e_style = Style.style((TextColor)TextColor.color((int)255, (int)96, (int)72));
        d_style = Style.style((TextColor)TextColor.color((int)0, (int)255, (int)255));
    }
}

