/*
 * Decompiled with CFR 0.152.
 */
package cn.lunadeer.dominion.uis.dominion.manage;

import cn.lunadeer.dominion.Dominion;
import cn.lunadeer.dominion.api.dtos.DominionDTO;
import cn.lunadeer.dominion.api.dtos.flag.EnvFlag;
import cn.lunadeer.dominion.api.dtos.flag.Flags;
import cn.lunadeer.dominion.commands.DominionFlagCommand;
import cn.lunadeer.dominion.configuration.uis.ChestUserInterface;
import cn.lunadeer.dominion.configuration.uis.TextUserInterface;
import cn.lunadeer.dominion.misc.Asserts;
import cn.lunadeer.dominion.misc.Converts;
import cn.lunadeer.dominion.uis.AbstractUI;
import cn.lunadeer.dominion.uis.MainMenu;
import cn.lunadeer.dominion.uis.dominion.DominionList;
import cn.lunadeer.dominion.uis.dominion.DominionManage;
import cn.lunadeer.dominion.utils.Misc;
import cn.lunadeer.dominion.utils.configuration.ConfigurationPart;
import cn.lunadeer.dominion.utils.scui.ChestButton;
import cn.lunadeer.dominion.utils.scui.ChestListView;
import cn.lunadeer.dominion.utils.scui.ChestUserInterfaceManager;
import cn.lunadeer.dominion.utils.scui.configuration.ButtonConfiguration;
import cn.lunadeer.dominion.utils.scui.configuration.ListViewConfiguration;
import cn.lunadeer.dominion.utils.stui.ListView;
import cn.lunadeer.dominion.utils.stui.components.Line;
import cn.lunadeer.dominion.utils.stui.components.buttons.FunctionalButton;
import cn.lunadeer.dominion.utils.stui.components.buttons.ListViewButton;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;

public class EnvSetting
extends AbstractUI {
    public static void show(CommandSender sender, String dominionName, String pageStr) {
        new EnvSetting().displayByPreference(sender, dominionName, pageStr);
    }

    public static ListViewButton button(final CommandSender sender, final String dominionName) {
        return (ListViewButton)new ListViewButton(TextUserInterface.envSettingTuiText.button){

            @Override
            public void function(String pageStr) {
                EnvSetting.show(sender, dominionName, pageStr);
            }
        }.needPermission(Dominion.defaultPermission);
    }

    @Override
    protected void showTUI(final Player player, String ... args) {
        final String dominionName = args[0];
        final String pageStr = args.length > 1 ? args[1] : "1";
        DominionDTO dominion = Converts.toDominionDTO(dominionName);
        Asserts.assertDominionAdmin(player, dominion);
        int page = Converts.toIntegrity(pageStr);
        ListView view = ListView.create(10, EnvSetting.button((CommandSender)player, dominionName));
        view.title(Misc.formatString(TextUserInterface.envSettingTuiText.title, dominion.getName())).navigator(Line.create().append(MainMenu.button((CommandSender)player).build()).append(DominionList.button((CommandSender)player).build()).append(DominionManage.button((CommandSender)player, dominionName).build()).append(TextUserInterface.envSettingTuiText.button));
        for (final EnvFlag flag : Flags.getAllEnvFlagsEnable()) {
            if (dominion.getEnvFlagValue(flag)) {
                view.add(Line.create().append(new FunctionalButton("\u2611"){

                    @Override
                    public void function() {
                        DominionFlagCommand.setEnv((CommandSender)player, dominionName, flag.getFlagName(), "false", pageStr);
                    }
                }.needPermission(Dominion.defaultPermission).green().build()).append((TextComponent)Component.text((String)flag.getDisplayName()).hoverEvent((HoverEventSource)Component.text((String)flag.getDescription()))));
                continue;
            }
            view.add(Line.create().append(new FunctionalButton("\u2610"){

                @Override
                public void function() {
                    DominionFlagCommand.setEnv((CommandSender)player, dominionName, flag.getFlagName(), "true", pageStr);
                }
            }.needPermission(Dominion.defaultPermission).red().build()).append((TextComponent)Component.text((String)flag.getDisplayName()).hoverEvent((HoverEventSource)Component.text((String)flag.getDescription()))));
        }
        view.showOn(player, page);
    }

    @Override
    protected void showCUI(final Player player, String ... args) {
        final DominionDTO dominion = Converts.toDominionDTO(args[0]);
        Asserts.assertDominionAdmin(player, dominion);
        ChestListView view = ChestUserInterfaceManager.getInstance().getListViewOf(player);
        view.setTitle(Misc.formatString(ChestUserInterface.envSettingCui.title, dominion.getName()));
        view.applyListConfiguration(ChestUserInterface.envSettingCui.listConfiguration, Converts.toIntegrity(args[1]));
        view.setButton(ChestUserInterface.envSettingCui.backButton.getSymbol(), new ChestButton(ChestUserInterface.envSettingCui.backButton){

            @Override
            public void onClick(ClickType type) {
                DominionManage.show((CommandSender)player, dominion.getName(), "1");
            }
        });
        for (int i = 0; i < Flags.getAllEnvFlagsEnable().size(); ++i) {
            final EnvFlag flag = Flags.getAllEnvFlagsEnable().get(i);
            final Integer page = (int)Math.ceil((double)(i + 1) / (double)view.getPageSize());
            String flagState = dominion.getEnvFlagValue(flag) ? ChestUserInterface.envSettingCui.flagItemStateTrue : ChestUserInterface.envSettingCui.flagItemStateFalse;
            String flagName = Misc.formatString(ChestUserInterface.envSettingCui.flagItemName, flag.getDisplayName());
            List<String> descriptions = Misc.foldLore2Line(flag.getDescription(), 30);
            List<String> flagLore = Misc.formatStringList(ChestUserInterface.envSettingCui.flagItemLore, flagState, descriptions.get(0), descriptions.get(1));
            ButtonConfiguration btnConfig = ButtonConfiguration.createMaterial(ChestUserInterface.envSettingCui.listConfiguration.itemSymbol.charAt(0), flag.getMaterial(), flagName, flagLore);
            view.addItem(new ChestButton(btnConfig){

                @Override
                public void onClick(ClickType type) {
                    DominionFlagCommand.setEnv((CommandSender)player, dominion.getName(), flag.getFlagName(), String.valueOf(!dominion.getEnvFlagValue(flag)), page.toString());
                }
            });
        }
        view.open();
    }

    public static class EnvSettingTuiText
    extends ConfigurationPart {
        public String title = "{0} Env Setting";
        public String button = "ENV SET";
        public String description = "Set environment of dominion.";
    }

    public static class EnvSettingCui
    extends ConfigurationPart {
        public String title = "\u00a76\u2726 \u00a72\u00a7lEnvironment of {0} \u00a76\u2726";
        public ListViewConfiguration listConfiguration = new ListViewConfiguration('i', List.of("<########", "#iiiiiii#", "#iiiiiii#", "#iiiiiii#", "p#######n"));
        public ButtonConfiguration backButton = ButtonConfiguration.createMaterial('<', Material.RED_STAINED_GLASS_PANE, "\u00a7c\u00ab Back to Dominion Management", List.of("\u00a77Return to the dominion", "\u00a77management menu.", "", "\u00a7e\u25b6 Click to go back"));
        public String flagItemName = "\u00a76\u2699\ufe0f \u00a7e{0}";
        public String flagItemStateTrue = "\u00a7a\u00a7l\u2713 ENABLED";
        public String flagItemStateFalse = "\u00a7c\u00a7l\u2717 DISABLED";
        public List<String> flagItemLore = List.of("\u00a77Status: {0}", "", "\u00a77Description:", "\u00a7f{1}", "\u00a7f{2}", "", "\u00a7e\u25b6 Click to toggle this setting", "\u00a78Changes take effect immediately");
    }
}

